function onThink(interval)
    -- Consulta itens pendentes na tabela gacha_delivery
    local resultId = db.storeQuery("SELECT `id`, `player_id`, `item_id`, `count` FROM `gacha_delivery` WHERE `delivered` = 0")

    if resultId ~= false then
        repeat
            local entryId = result.getNumber(resultId, "id")
            local playerId = result.getNumber(resultId, "player_id")
            local itemId = result.getNumber(resultId, "item_id")
            local count = result.getNumber(resultId, "count")

            -- Tenta encontrar o jogador online
            local player = Player(playerId)

            if player then
                -- Verifica se o jogador tem capacidade e espaço (opcional, mas recomendado)
                if player:getFreeCapacity() >= ItemType(itemId):getWeight(count) then
                    
                    -- Adiciona o item ao jogador (pode ir pro inbox ou inventário)
                    -- player:addItem(itemId, count) -- Joga na backpack
                    -- OU
                    player:addItemToInbox(itemId, count) -- Joga no Inbox (Recomendado para servidores modernos)

                    player:sendTextMessage(MESSAGE_EVENT_ADVANCE, "Parabens! Voce recebeu um item do Gacha: " .. ItemType(itemId):getName())
                    player:getPosition():sendMagicEffect(CONST_ME_FIREWORK_RED) -- Efeito visual

                    -- Marca como entregue no banco de dados
                    db.query("UPDATE `gacha_delivery` SET `delivered` = 1 WHERE `id` = " .. entryId)
                    print("> [Gacha System] Item entregue para " .. player:getName())
                else
                    player:sendTextMessage(MESSAGE_STATUS_SMALL, "Gacha: Voce tem um premio pendente, mas sem capacidade para receber.")
                end
            end
        until not result.next(resultId)
        result.free(resultId)
    end
    return true
end