-- Arquivo: data/globalevents/scripts/shop.lua

function onThink(interval, lastExecution)
    -- Busca todos os itens com status 'pending'
    local result = db.getResult("SELECT id, account_id, offer_name, itemid, count, points_cost FROM shop_history WHERE status = 'pending'")
    
    if(result:getID() ~= -1) then
        while(true) do
            local log_id = tonumber(result:getDataInt("id"))
            local account_id = tonumber(result:getDataInt("account_id"))
            local itemid = tonumber(result:getDataInt("itemid"))
            local count = tonumber(result:getDataInt("count"))
            local offer_name = result:getDataString("offer_name")
            
            -- Tenta achar o player online pela conta
            local player = getPlayerByAccountId(account_id)
            local delivered = false
            local message = "SHOP: Sua compra ("..offer_name..") foi entregue!"

            if isPlayer(player) then
                if itemid == 0 and string.find(offer_name, "Premium") then
                    -- LÓGICA VIP/PREMIUM DAYS (Se itemid for 0, trata como serviço)
                    -- O campo 'count' está sendo usado para guardar o número de dias
                    doPlayerAddPremiumDays(player, count)
                    message = "SHOP: Adicionamos "..count.." dias Premium na sua conta. Obrigado!"
                    delivered = true
                elseif itemid > 0 then
                    -- LÓGICA DE ITENS (Itens, Stones, Coins, etc.)
                    local free_cap = getPlayerFreeCap(player)
                    local item_weight = getItemWeightById(itemid, count)
                    
                    if item_weight <= free_cap then
                        if doPlayerAddItem(player, itemid, count) then
                            delivered = true
                            message = "SHOP: Seu item ("..offer_name.." - "..count.."x) chegou na sua BP!"
                        else
                            -- Se falhar a entrega (Ex: Item não cabe no depot ou na bag)
                            message = "SHOP: Erro ao adicionar item. Tente liberar espaço no Depot e relogue."
                        end
                    else
                        message = "SHOP: Seu personagem nao tem capacidade (CAP) para receber o item. Libere espaço na BP ou no Depot."
                    end
                else
                    -- Lógica para RK/Troca Nick (Geralmente a PHP já seta como delivered, mas se cair aqui, é um serviço desconhecido)
                    delivered = true
                    message = "SHOP: Seu serviço ('"..offer_name.."') foi processado."
                end
                
                -- Envia a mensagem ao jogador
                doPlayerSendTextMessage(player, MESSAGE_STATUS_CONSOLE_ORANGE, message)
            end
            
            -- Se a entrega foi bem sucedida ou se é um serviço que não precisa de item (RK/VIP)
            if delivered then
                db.executeQuery("UPDATE shop_history SET status = 'delivered' WHERE id = " .. log_id)
            end

            if not(result:next()) then
                break
            end
        end
        result:free()
    end
    return true
end

-- Helper (Geralmente necessário em TFS mais antigos)
function getPlayerByAccountId(accId)
    for _, pid in ipairs(getPlayersOnline()) do
        if getPlayerAccountId(pid) == accId then
            return pid
        end
    end
    return nil
end