<?php
// ==========================================================
// ARQUIVO: account.php
// TEMA: Cyber Dark Glass
// FUNÇÃO: Dashboard da Conta com Char Bazaar Integrado
// ==========================================================

ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
require 'includes/conexao.php';

// --- CONFIGURAÇÃO ---
function getSiteConfigFromDB($pdo) {
    try {
        $stmt = $pdo->query("SELECT server_name FROM site_config WHERE id = 1");
        $config = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($config) return $config;
    } catch (PDOException $e) {}
    return ['server_name' => 'PokeDash'];
}
$siteConfig = getSiteConfigFromDB($pdo);
$page_title = "Minha Conta - " . $siteConfig['server_name'];

if (!isset($_SESSION['account_id'])) {
    header("Location: login.php");
    exit;
}

$account_id = $_SESSION['account_id'];
$msg = '';

// Verifica se há mensagem temporária de redirecionamento (ex: após venda/cancelamento)
if (isset($_SESSION['temp_msg'])) {
    $msg = $_SESSION['temp_msg'];
    unset($_SESSION['temp_msg']);
}

$generated_key = false;

// --- GERAR RK ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['generate_rk'])) {
    $chk = $pdo->prepare("SELECT recovery_key FROM accounts WHERE id = ?");
    $chk->execute([$account_id]);
    
    if (empty($chk->fetch()['recovery_key'])) {
        $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $new_key = substr(str_shuffle($chars), 0, 4) . '-' . substr(str_shuffle($chars), 0, 4) . '-' . substr(str_shuffle($chars), 0, 4) . '-' . substr(str_shuffle($chars), 0, 4);
        
        $upd = $pdo->prepare("UPDATE accounts SET recovery_key = ? WHERE id = ?");
        if ($upd->execute([$new_key, $account_id])) {
            $generated_key = $new_key;
            $msg = '<div class="alert alert-success border-0 shadow-lg text-white fw-bold" style="background: #10b981;"><i class="fas fa-check-circle me-2"></i> RK Gerada com sucesso!</div>';
        }
    } else {
        $msg = '<div class="alert alert-danger border-0 shadow-lg text-white fw-bold" style="background: #ef4444;"><i class="fas fa-times-circle me-2"></i> Você já possui uma Recovery Key.</div>';
    }
}

// --- CONFIGURAÇÕES DO CHAR BAZAAR ---
$sellerConfigStmt = $pdo->query("SELECT admin_commission_percent, char_item_storage_key, min_level_to_sell, min_price_pps FROM character_seller_config WHERE id = 1");
$sellerConfig = $sellerConfigStmt->fetch(PDO::FETCH_ASSOC);
$minLevel = $sellerConfig['min_level_to_sell'] ?? 100;
$minPrice = $sellerConfig['min_price_pps'] ?? 50;
$commission_percent = $sellerConfig['admin_commission_percent'] ?? 10;
$storage_key = $sellerConfig['char_item_storage_key'] ?? 98765;

// --- DADOS DA CONTA (post_points para PPS) ---
$stmt = $pdo->prepare("SELECT id, name, password, email, premdays, post_points, creation, recovery_key FROM accounts WHERE id = ?");
$stmt->execute([$account_id]);
$account = $stmt->fetch(PDO::FETCH_ASSOC);

// --- PERSONAGENS ---
$stmtChars = $pdo->prepare("
    SELECT p.*, 
           g.id as guild_id, g.name as guild_name, 
           gr.level as rank_level
    FROM players p 
    LEFT JOIN guild_membership gm ON p.id = gm.player_id
    LEFT JOIN guilds g ON gm.guild_id = g.id
    LEFT JOIN guild_ranks gr ON gm.rank_id = gr.id
    WHERE p.account_id = ? 
    ORDER BY p.name ASC
");
$stmtChars->execute([$account_id]);
$characters = $stmtChars->fetchAll(PDO::FETCH_ASSOC);

$managableGuild = null;
foreach ($characters as $char) {
    if ($char['rank_level'] >= 2) {
        $managableGuild = ['id' => $char['guild_id'], 'name' => $char['guild_name']];
        break;
    }
}

// --- SUPORTE ---
$stmtTicket = $pdo->prepare("SELECT id, subject, status FROM support_tickets WHERE account_id = ? AND status = 'Resposta Admin' LIMIT 1");
$stmtTicket->execute([$account_id]);
$answeredTicket = $stmtTicket->fetch(PDO::FETCH_ASSOC);

// Métricas Visuais
$hasRK = !empty($account['recovery_key']);
$vipPercent = ($account['premdays'] > 360) ? 100 : (($account['premdays'] / 30) * 100);

// Cálculo de "Fidelidade" da conta (Exemplo: base de 1000 dias para barra cheia)
$daysCreated = (time() - $account['creation']) / (60 * 60 * 24);
$loyaltyPercent = min(100, ($daysCreated / 365) * 100);

function getVocName($id) {
    $vocs = [0 => 'Novato', 1 => 'Treinador', 2 => 'Mestre', 3 => 'Elite'];
    return $vocs[$id] ?? 'Treinador';
}

include 'includes/header.php';
?>

<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

<style>
    /* Estilos Dark Cyber Glass */
    :root {
        --bg-deep: #020617;      /* Fundo quase preto */
        --glass: rgba(30, 41, 59, 0.7); /* Vidro escuro */
        --glass-border: rgba(255, 255, 255, 0.1);
        --neon-blue: #3b82f6;
        --neon-gold: #fbbf24;
        --neon-green: #10b981;
        --neon-red: #ef4444;
        --text-bright: #ffffff;
        --text-soft: rgba(255, 255, 255, 0.75); /* Substitui o cinza */
    }

    body {  
        background-color: var(--bg-deep);  
        background-image: radial-gradient(circle at 50% 0%, #1e1b4b 0%, var(--bg-deep) 70%);
        color: var(--text-bright);
        font-family: 'Segoe UI', sans-serif;
    }

    /* GLASS CARDS */
    .glass-card {
        background: var(--glass);
        backdrop-filter: blur(12px);
        -webkit-backdrop-filter: blur(12px);
        border: 1px solid var(--glass-border);
        border-radius: 16px;
        box-shadow: 0 4px 30px rgba(0, 0, 0, 0.3);
        transition: transform 0.3s, border-color 0.3s;
    }
    .glass-card:hover {
        transform: translateY(-5px);
        border-color: rgba(255, 255, 255, 0.3);
    }

    /* SIDEBAR */
    .sidebar-profile {
        text-align: center;
        padding: 30px 20px;
        background: linear-gradient(180deg, rgba(255,255,255,0.05) 0%, transparent 100%);
        border-radius: 16px 16px 0 0;
    }
    .avatar-glow {
        width: 90px; height: 90px;
        background: linear-gradient(45deg, var(--neon-blue), #60a5fa);
        border-radius: 50%;
        display: flex; align-items: center; justify-content: center;
        font-size: 2.5rem; font-weight: 800; color: white;
        margin: 0 auto 15px auto;
        box-shadow: 0 0 25px rgba(59, 130, 246, 0.4);
        border: 2px solid white;
    }
    .nav-btn {
        display: flex; align-items: center;
        padding: 15px 20px;
        color: var(--text-soft);
        font-weight: 600;
        text-decoration: none;
        transition: 0.3s;
        border-left: 3px solid transparent;
    }
    .nav-btn:hover, .nav-btn.active {
        background: rgba(255,255,255,0.05);
        color: white;
        border-left-color: var(--neon-blue);
    }
    .nav-btn i { width: 30px; text-align: center; margin-right: 10px; }

    /* DASH HEADER */
    .dash-hero {
        background: linear-gradient(90deg, #172554 0%, #0f172a 100%);
        padding: 40px;
        border-radius: 16px;
        border: 1px solid var(--glass-border);
        position: relative;
        overflow: hidden;
    }
    .dash-hero::after {
        content: ''; position: absolute; right: 0; top: 0; bottom: 0; width: 40%;
        background: url('images/pokeball_transparent.png') no-repeat center right;
        background-size: contain; opacity: 0.1; pointer-events: none;
    }
    
    /* STATS BOXES */
    .stat-box {
        background: rgba(255,255,255,0.03);
        border-radius: 12px;
        padding: 15px;
        text-align: center;
        border: 1px solid var(--glass-border);
    }
    .stat-label { font-size: 0.8rem; text-transform: uppercase; letter-spacing: 1px; color: var(--text-soft); }
    .stat-value { font-size: 1.8rem; font-weight: 800; color: white; text-shadow: 0 0 10px rgba(255,255,255,0.3); }

    /* PPS Highlight */
    .pps-display {
        color: var(--neon-gold);
        text-shadow: 0 0 15px rgba(251, 191, 36, 0.4);
    }

    /* CHARACTERS */
    .char-row {
        background: rgba(0,0,0,0.2);
        border-bottom: 1px solid var(--glass-border);
        padding: 15px;
        display: flex; align-items: center;
        transition: 0.2s;
    }
    .char-row:last-child { border-bottom: none; }
    .char-row:hover { background: rgba(255,255,255,0.05); }

    /* BARS */
    .progress-micro { height: 6px; background: rgba(255,255,255,0.1); border-radius: 10px; overflow: hidden; margin-top: 5px; }
    .bar-hp { background: var(--neon-red); height: 100%; box-shadow: 0 0 10px rgba(239, 68, 68, 0.5); }
    .bar-mp { background: var(--neon-blue); height: 100%; box-shadow: 0 0 10px rgba(59, 130, 246, 0.5); }
    .bar-xp { background: linear-gradient(90deg, #ec4899, #8b5cf6); height: 100%; }

    /* DAILY REWARD WIDGET (SURPRESA) */
    .daily-reward {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        border-radius: 12px;
        padding: 20px;
        color: white;
        position: relative;
        overflow: hidden;
        cursor: pointer;
        transition: 0.3s;
    }
    .daily-reward:hover { transform: scale(1.02); box-shadow: 0 0 20px rgba(245, 158, 11, 0.4); }
    .daily-icon { font-size: 2.5rem; margin-bottom: 10px; animation: bounce 2s infinite; }
    
    @keyframes bounce { 0%, 100% { transform: translateY(0); } 50% { transform: translateY(-10px); } }

    /* RK BOX */
    .rk-display {
        font-family: 'Courier New', monospace;
        background: #000;
        color: var(--neon-green);
        border: 1px dashed var(--neon-green);
        padding: 15px;
        font-size: 1.4rem;
        letter-spacing: 3px;
        border-radius: 8px;
    }
</style>

<div class="container my-5">
    <div class="row g-4">
        
        <div class="col-lg-3">
            <div class="glass-card h-100" data-aos="fade-right">
                <div class="sidebar-profile">
                    <div class="avatar-glow">
                        <?php echo strtoupper(substr($account['name'], 0, 1)); ?>
                    </div>
                    <h5 class="fw-bold text-white mb-1"><?php echo htmlspecialchars($account['name']); ?></h5>
                    <p class="text-soft mb-3 small"><?php echo $account['email']; ?></p>
                    
                    <div class="px-3">
                        <div class="d-flex justify-content-between small text-white mb-1">
                            <span>Nível da Conta</span>
                            <span><?php echo floor($daysCreated/30); ?></span>
                        </div>
                        <div class="progress-micro" style="height: 4px;">
                            <div class="bar-xp" style="width: <?php echo $loyaltyPercent; ?>%"></div>
                        </div>
                    </div>
                </div>

                <div class="d-flex flex-column py-2">
                    <a href="account.php" class="nav-btn active"><i class="fas fa-columns"></i> Dashboard</a>
                    <a href="create_character.php" class="nav-btn"><i class="fas fa-user-plus"></i> Novo Personagem</a>
                    <a href="shop.php" class="nav-btn"><i class="fas fa-gem text-warning"></i> Loja de PPS</a>
                    <a href="char_bazaar.php" class="nav-btn"><i class="fas fa-handshake text-success"></i> Character Bazaar</a>
                    
                    <?php if ($managableGuild): ?>
                        <a href="guilds.php?view=<?php echo $managableGuild['id']; ?>#manage" class="nav-btn text-info">
                            <i class="fas fa-crown"></i> Gerenciar Guilda
                        </a>
                    <?php endif; ?>

                    <a href="suporte.php" class="nav-btn">
                        <i class="fas fa-life-ring"></i> Suporte
                        <?php if($answeredTicket): ?><span class="badge bg-danger ms-auto">1</span><?php endif; ?>
                    </a>
                    
                    <div class="my-2 border-top border-white opacity-10"></div>
                    
                    <a href="#" data-bs-toggle="modal" data-bs-target="#changePassModal" class="nav-btn"><i class="fas fa-key"></i> Segurança</a>
                    <a href="logout.php" class="nav-btn text-danger fw-bold"><i class="fas fa-power-off"></i> Sair</a>
                </div>
            </div>
        </div>

        <div class="col-lg-9">
            
            <div class="dash-hero mb-4" data-aos="fade-down">
                <div class="row align-items-center">
                    <div class="col-md-8">
                        <small class="text-info fw-bold text-uppercase mb-2 d-block">Bem-vindo de volta</small>
                        <h2 class="fw-bold text-white display-6 mb-3">Painel do Jogador</h2>
                        <div class="d-flex gap-3 flex-wrap">
                            <div class="d-flex align-items-center text-soft">
                                <i class="far fa-calendar-alt me-2 text-primary"></i> 
                                Criada em: <?php echo date('d/m/Y', $account['creation']); ?>
                            </div>
                            <div class="d-flex align-items-center text-soft">
                                <i class="fas fa-shield-alt me-2 <?php echo $hasRK ? 'text-success' : 'text-danger'; ?>"></i>
                                Status: <?php echo $hasRK ? 'Segura' : 'Risco'; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 text-md-end mt-4 mt-md-0">
                        <div class="glass-card p-3 d-inline-block text-start" style="min-width: 180px; background: rgba(0,0,0,0.3);">
                            <small class="text-soft d-block text-uppercase" style="font-size: 0.7rem;">Saldo Disponível</small>
                            <div class="stat-value pps-display"><?php echo number_format($account['post_points'], 0, ',', '.'); ?> PPS</div>
                            <a href="donate.php" class="btn btn-warning btn-sm w-100 fw-bold mt-2 shadow-sm" style="color: #000;">
                                <i class="fas fa-plus-circle me-1"></i> Comprar PPS
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <?php echo $msg; ?>

            <?php if ($generated_key): ?>
                <div class="glass-card border-success p-4 mb-4 text-center">
                    <i class="fas fa-lock fa-3x text-success mb-3"></i>
                    <h3 class="text-white fw-bold">Recovery Key Gerada!</h3>
                    <p class="text-white">Anote este código agora. Ele não será exibido novamente.</p>
                    <div class="rk-display mb-3"><?php echo $generated_key; ?></div>
                    <button class="btn btn-outline-light btn-sm" onclick="window.print()">Imprimir</button>
                </div>
            <?php endif; ?>

            <div class="row g-4 mb-4">
                <div class="col-md-8">
                    <div class="glass-card h-100 p-4" data-aos="fade-up">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h5 class="fw-bold text-white m-0"><i class="fas fa-crown text-warning me-2"></i> Status VIP</h5>
                            <span class="badge bg-warning text-dark fw-bold px-3 py-2 rounded-pill">
                                <?php echo ($account['premdays'] > 0) ? "ATIVO" : "INATIVO"; ?>
                            </span>
                        </div>
                        
                        <div class="row align-items-center">
                            <div class="col-6 border-end border-secondary">
                                <div class="stat-value text-white"><?php echo $account['premdays']; ?></div>
                                <div class="stat-label">Dias Restantes</div>
                            </div>
                            <div class="col-6 ps-4">
                                <p class="text-soft small mb-2">Benefícios:</p>
                                <ul class="list-unstyled text-white small m-0">
                                    <li><i class="fas fa-check text-success me-2"></i> +50% Experiência</li>
                                    <li><i class="fas fa-check text-success me-2"></i> Acesso a Ilhas VIPs</li>
                                </ul>
                            </div>
                        </div>
                        <div class="mt-3">
                             <div class="progress-micro bg-dark">
                                 <div class="bg-warning h-100" style="width: <?php echo $vipPercent; ?>%"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="daily-reward h-100 text-center d-flex flex-column justify-content-center" data-aos="zoom-in" onclick="Swal.fire('Em breve!', 'Sistema de recompensa diária em desenvolvimento.', 'info')">
                        <i class="fas fa-gift daily-icon"></i>
                        <h5 class="fw-bold m-0">Resgatar Diário</h5>
                        <small class="opacity-75">Clique para coletar</small>
                    </div>
                </div>
            </div>

            <?php if(!$hasRK && !$generated_key): ?>
                <div class="alert alert-danger bg-danger bg-opacity-25 border-danger text-white d-flex align-items-center justify-content-between mb-4 shadow-sm">
                    <div>
                        <i class="fas fa-exclamation-triangle me-2"></i> <strong>Sua conta está vulnerável!</strong>
                        <div class="small opacity-75">Sem uma Recovery Key, você não pode recuperar sua senha se perdê-la.</div>
                    </div>
                    <form method="POST" onsubmit="return confirm('ATENÇÃO: A chave será mostrada apenas uma vez. Tem certeza?');">
                        <button type="submit" name="generate_rk" class="btn btn-danger btn-sm fw-bold shadow">GERAR RK</button>
                    </form>
                </div>
            <?php endif; ?>

            <div class="d-flex justify-content-between align-items-end mb-3">
                <h4 class="fw-bold text-white m-0 border-start border-4 border-primary ps-3">Meus Personagens</h4>
                <a href="create_character.php" class="btn btn-primary btn-sm rounded-pill fw-bold shadow-sm">
                    <i class="fas fa-plus me-1"></i> Criar Novo
                </a>
            </div>

            <div class="glass-card overflow-hidden">
                <?php if(empty($characters)): ?>
                    <div class="p-5 text-center">
                        <i class="fas fa-users-slash fa-3x text-soft mb-3 opacity-50"></i>
                        <p class="text-soft">Nenhum personagem encontrado.</p>
                    </div>
                <?php else: ?>
                    <?php foreach($characters as $char): 
                        $hpP = ($char['healthmax'] > 0) ? ($char['health'] / $char['healthmax']) * 100 : 0;
                        $mpP = ($char['manamax'] > 0) ? ($char['mana'] / $char['manamax']) * 100 : 0;
                        // URL de outfit ajustada para o exemplo do seu código DDL
                        $outfit = "https://outfit-images.ots.me/1285_walk_animation/animoutfit.php?id={$char['looktype']}&head={$char['lookhead']}&body={$char['lookbody']}&legs={$char['looklegs']}&feet={$char['lookfeet']}";
                        
                        $canSell = $char['level'] >= $minLevel;
                        $isSelling = $char['on_sale'] == 1;
                    ?>
                    <div class="char-row">
                        <div class="me-3 position-relative">
                            <div style="width: 50px; height: 50px; background: rgba(255,255,255,0.05); border-radius: 50%; display:flex; align-items:center; justify-content:center;">
                                <img src="<?php echo $outfit; ?>" style="margin-top: -10px; margin-left: -10px;">
                            </div>
                            <span class="position-absolute bottom-0 end-0 badge rounded-circle p-1 border border-dark <?php echo ($char['online']) ? 'bg-success' : 'bg-danger'; ?>" style="width: 12px; height: 12px;"> </span>
                        </div>

                        <div class="flex-grow-1">
                            <div class="d-flex align-items-center mb-1">
                                <h5 class="fw-bold text-white m-0 me-2">
                                    <a href="character.php?name=<?php echo urlencode($char['name']); ?>" class="text-white text-decoration-none">
                                        <?php echo htmlspecialchars($char['name']); ?>
                                    </a>
                                </h5>
                                <span class="badge bg-dark border border-secondary text-soft" style="font-size: 0.65rem;">Lvl <?php echo $char['level']; ?></span>
                                <?php if ($isSelling): ?>
                                    <span class="badge bg-success ms-2 fw-bold"><i class="fas fa-tag me-1"></i> À VENDA (<?php echo number_format($char['sale_price'], 0, ',', '.'); ?> PPS)</span>
                                <?php endif; ?>
                            </div>
                            <div class="small text-soft">
                                <?php echo getVocName($char['vocation']); ?> • 
                                <?php echo $char['guild_name'] ? '<span class="text-info">'.$char['guild_name'].'</span>' : 'Sem Guilda'; ?>
                            </div>
                        </div>

                        <div class="d-none d-md-block w-25 mx-4">
                            <div class="d-flex justify-content-between small text-white" style="font-size: 0.6rem;">
                                <span>HP</span> <span><?php echo $char['health']; ?></span>
                            </div>
                            <div class="progress-micro mb-1"><div class="bar-hp" style="width: <?php echo $hpP; ?>%"></div></div>
                            
                            <div class="d-flex justify-content-between small text-white" style="font-size: 0.6rem;">
                                <span>MP</span> <span><?php echo $char['mana']; ?></span>
                            </div>
                            <div class="progress-micro"><div class="bar-mp" style="width: <?php echo $mpP; ?>%"></div></div>
                        </div>

                        <div class="dropup">
                            <button class="btn btn-link text-white opacity-50 p-0" type="button" data-bs-toggle="dropdown" aria-expanded="false" id="dropdownMenuChar<?php echo $char['id']; ?>">
                                <i class="fas fa-ellipsis-v fa-lg"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-dark dropdown-menu-end shadow" aria-labelledby="dropdownMenuChar<?php echo $char['id']; ?>">
                                <li><a class="dropdown-item" href="character.php?name=<?php echo urlencode($char['name']); ?>"><i class="fas fa-user me-2"></i> Perfil Público</a></li>
                                <li><a class="dropdown-item" href="#"><i class="fas fa-tshirt me-2"></i> Editar Outfit</a></li>
                                
                                <li><hr class="dropdown-divider"></li>
                                
                                <?php if ($isSelling): ?>
                                    <li><a class="dropdown-item text-warning fw-bold" href="sell_character.php?action=cancel&id=<?php echo $char['id']; ?>" onclick="return confirm('Tem certeza que deseja cancelar a venda de <?php echo htmlspecialchars($char['name']); ?>?');"><i class="fas fa-times-circle me-2"></i> Cancelar Venda</a></li>
                                <?php elseif (!$canSell): ?>
                                    <li><button class="dropdown-item disabled" type="button" title="Nível mínimo para venda: <?php echo $minLevel; ?>"><i class="fas fa-lock me-2"></i> Nível baixo (<?php echo $minLevel; ?>)</button></li>
                                <?php elseif ($char['online'] == 1): ?>
                                    <li><button class="dropdown-item disabled" type="button" title="O personagem deve estar offline."><i class="fas fa-plug me-2"></i> Personagem Online</button></li>
                                <?php else: ?>
                                    <li><button class="dropdown-item text-success fw-bold" type="button" data-bs-toggle="modal" data-bs-target="#sellModal<?php echo $char['id']; ?>"><i class="fas fa-handshake me-2"></i> Colocar à Venda</button></li>
                                <?php endif; ?>

                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item text-danger" href="#"><i class="fas fa-trash-alt me-2"></i> Deletar</a></li>
                            </ul>
                        </div>
                        </div>
                    
                    <?php 
                    // Inclui o modal para cada personagem - É OBRIGATÓRIO TER ESTE ARQUIVO
                    // O arquivo 'modals/sell_character_modal.php' deve ter o ID de modal correto: sellModal{char_id}
                    include 'modals/sell_character_modal.php'; 
                    ?>
                    
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>

        </div>
    </div>
</div>

<div class="modal fade" id="changePassModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content text-white" style="background: #1e293b; border: 1px solid rgba(255,255,255,0.1);">
      <div class="modal-header border-secondary">
        <h5 class="modal-title fw-bold">Alterar Senha</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form action="changepass.php" method="POST">
            <div class="mb-3">
                <label class="text-soft small">Senha Atual</label>
                <input type="password" name="old_pass" class="form-control bg-dark text-white border-secondary" required>
            </div>
            <div class="mb-3">
                <label class="text-soft small">Nova Senha</label>
                <input type="password" name="new_pass" class="form-control bg-dark text-white border-secondary" required>
            </div>
            <div class="mb-3">
                <label class="text-soft small">Confirmar Nova Senha</label>
                <input type="password" name="conf_pass" class="form-control bg-dark text-white border-secondary" required>
            </div>
            <button type="submit" class="btn btn-primary w-100 fw-bold shadow">SALVAR</button>
        </form>
      </div>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    AOS.init({ once: true });
</script>

<?php include 'includes/footer.php'; ?>