<?php
// admin/manage_content.php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
require '../includes/conexao.php';

// SEGURANÇA
if (!isset($_SESSION['account_id'])) { header("Location: ../login.php"); exit; }
$stmt = $pdo->prepare("SELECT page_access FROM accounts WHERE id = ?");
$stmt->execute([$_SESSION['account_id']]);
$acc = $stmt->fetch();
if (!$acc || $acc['page_access'] < 3) die("Acesso Negado.");

$page_title = "Gerenciar Conteúdo (Badges & Quests)";
if(file_exists('../includes/admin_header.php')) include '../includes/admin_header.php';
else include '../includes/header.php';

$msg = '';

// --- PROCESSAR FORMULÁRIOS ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Adicionar Badge
    if (isset($_POST['add_badge'])) {
        $stmt = $pdo->prepare("INSERT INTO site_badges (name, storage_id, icon, color) VALUES (?, ?, ?, ?)");
        if ($stmt->execute([$_POST['name'], $_POST['storage'], $_POST['icon'], $_POST['color']])) {
            $msg = '<div class="alert alert-success fw-bold"><i class="fas fa-check-circle me-2"></i> Insígnia adicionada!</div>';
        }
    }
    // Deletar Badge
    if (isset($_POST['del_badge'])) {
        $stmt = $pdo->prepare("DELETE FROM site_badges WHERE id = ?");
        $stmt->execute([$_POST['del_badge']]);
        $msg = '<div class="alert alert-warning fw-bold"><i class="fas fa-trash me-2"></i> Insígnia removida.</div>';
    }

    // Adicionar Quest
    if (isset($_POST['add_quest'])) {
        $stmt = $pdo->prepare("INSERT INTO site_quests (name, storage_id) VALUES (?, ?)");
        if ($stmt->execute([$_POST['name'], $_POST['storage']])) {
            $msg = '<div class="alert alert-success fw-bold"><i class="fas fa-check-circle me-2"></i> Quest adicionada!</div>';
        }
    }
    // Deletar Quest
    if (isset($_POST['del_quest'])) {
        $stmt = $pdo->prepare("DELETE FROM site_quests WHERE id = ?");
        $stmt->execute([$_POST['del_quest']]);
        $msg = '<div class="alert alert-warning fw-bold"><i class="fas fa-trash me-2"></i> Quest removida.</div>';
    }
}

// Buscar Dados
$badges = $pdo->query("SELECT * FROM site_badges ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
$quests = $pdo->query("SELECT * FROM site_quests ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
    /* Admin Dark Theme - Correção de Cores */
    body { background-color: #0f172a; color: #ffffff; font-family: 'Poppins', sans-serif; }
    
    .card { 
        background-color: #1e293b; 
        border: 1px solid rgba(255,255,255,0.1); 
        border-radius: 12px; 
    }
    
    .form-control { 
        background-color: #0f172a; 
        border: 1px solid #334155; 
        color: #ffffff; 
        font-weight: 500;
    }
    
    .form-control::placeholder { color: #94a3b8; } /* Placeholder mais claro */
    
    .form-control:focus { 
        background-color: #0f172a; 
        color: #ffffff; 
        border-color: #3b82f6; 
        box-shadow: 0 0 0 0.25rem rgba(59, 130, 246, 0.25);
    }
    
    /* Tabelas Full White Text */
    .table { color: #ffffff !important; }
    .table thead th { 
        background-color: #0f172a; 
        color: #cbd5e1; /* Cinza bem claro para cabeçalho */
        border-bottom: 2px solid #334155; 
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.85rem;
    }
    .table tbody tr { border-bottom: 1px solid #334155; }
    .table tbody tr:hover { background-color: rgba(255,255,255,0.05); }
    .table td { vertical-align: middle; }

    /* Botões */
    .btn-primary { background-color: #3b82f6; border: none; font-weight: bold; }
    .btn-primary:hover { background-color: #2563eb; }
    .btn-danger { background-color: #ef4444; border: none; }
</style>

<div class="container my-5">
    <div class="d-flex align-items-center mb-4 border-bottom border-secondary pb-3">
        <i class="fas fa-gamepad fa-2x text-primary me-3"></i>
        <div>
            <h2 class="fw-bold text-white mb-0">Gerenciar Conteúdo</h2>
            <p class="text-white-50 m-0">Adicione Insígnias e Quests para aparecerem no perfil dos jogadores.</p>
        </div>
    </div>

    <?php echo $msg; ?>

    <div class="row g-4">
        <div class="col-lg-6">
            <div class="card shadow h-100">
                <div class="card-header fw-bold text-white bg-transparent border-bottom border-secondary py-3">
                    <i class="fas fa-medal text-warning me-2"></i> Insígnias (Gym Badges)
                </div>
                <div class="card-body">
                    <form method="POST" class="row g-2 mb-4">
                        <div class="col-6">
                            <input type="text" name="name" class="form-control" placeholder="Nome (Ex: Boulder)" required>
                        </div>
                        <div class="col-6">
                            <input type="number" name="storage" class="form-control" placeholder="Storage ID" required>
                        </div>
                        <div class="col-6">
                            <input type="text" name="icon" class="form-control" placeholder="Icone (Ex: fa-bolt)" required>
                        </div>
                        <div class="col-4">
                            <input type="color" name="color" class="form-control form-control-color w-100" value="#fbbf24" required title="Escolha a cor">
                        </div>
                        <div class="col-2">
                            <button type="submit" name="add_badge" class="btn btn-primary w-100 h-100"><i class="fas fa-plus"></i></button>
                        </div>
                    </form>

                    <div class="table-responsive">
                        <table class="table table-sm align-middle">
                            <thead>
                                <tr>
                                    <th>Nome</th>
                                    <th>Storage</th>
                                    <th class="text-center">Visual</th>
                                    <th class="text-end">Ação</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(count($badges) > 0): ?>
                                    <?php foreach($badges as $b): ?>
                                    <tr>
                                        <td class="fw-bold"><?php echo htmlspecialchars($b['name']); ?></td>
                                        <td class="font-monospace text-info"><?php echo $b['storage_id']; ?></td>
                                        <td class="text-center">
                                            <i class="fas <?php echo htmlspecialchars($b['icon']); ?> fa-lg" style="color: <?php echo htmlspecialchars($b['color']); ?>"></i>
                                        </td>
                                        <td class="text-end">
                                            <form method="POST" style="display:inline;">
                                                <input type="hidden" name="del_badge" value="<?php echo $b['id']; ?>">
                                                <button class="btn btn-sm btn-danger px-2" onclick="return confirm('Tem certeza?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr><td colspan="4" class="text-center text-muted py-3">Nenhuma insígnia cadastrada.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card shadow h-100">
                <div class="card-header fw-bold text-white bg-transparent border-bottom border-secondary py-3">
                    <i class="fas fa-scroll text-info me-2"></i> Quests (Missões)
                </div>
                <div class="card-body">
                    <form method="POST" class="row g-2 mb-4">
                        <div class="col-6">
                            <input type="text" name="name" class="form-control" placeholder="Nome da Quest" required>
                        </div>
                        <div class="col-4">
                            <input type="number" name="storage" class="form-control" placeholder="Storage ID" required>
                        </div>
                        <div class="col-2">
                            <button type="submit" name="add_quest" class="btn btn-primary w-100 h-100"><i class="fas fa-plus"></i></button>
                        </div>
                    </form>

                    <div class="table-responsive">
                        <table class="table table-sm align-middle">
                            <thead>
                                <tr>
                                    <th>Nome da Quest</th>
                                    <th>Storage ID</th>
                                    <th class="text-end">Ação</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(count($quests) > 0): ?>
                                    <?php foreach($quests as $q): ?>
                                    <tr>
                                        <td class="fw-bold"><?php echo htmlspecialchars($q['name']); ?></td>
                                        <td class="font-monospace text-warning"><?php echo $q['storage_id']; ?></td>
                                        <td class="text-end">
                                            <form method="POST" style="display:inline;">
                                                <input type="hidden" name="del_quest" value="<?php echo $q['id']; ?>">
                                                <button class="btn btn-sm btn-danger px-2" onclick="return confirm('Tem certeza?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr><td colspan="3" class="text-center text-muted py-3">Nenhuma quest cadastrada.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php if(file_exists('../includes/admin_footer.php')) include '../includes/admin_footer.php'; else include '../includes/footer.php'; ?>