<?php
// api/gacha_spin.php
session_start();
header('Content-Type: application/json');

require '../includes/conexao.php';
require '../includes/gacha_engine.php';

// 1. VERIFICAÇÃO DE LOGIN
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_SESSION['account_id'])) {
    echo json_encode(['success' => false, 'error' => 'Você precisa estar logado.']);
    exit;
}

// 2. RECEBER DADOS
$input = json_decode(file_get_contents('php://input'), true);
$optionIndex = isset($input['option_index']) ? (int)$input['option_index'] : 1;
$charId = isset($input['char_id']) ? (int)$input['char_id'] : 0;

if (!in_array($optionIndex, [1, 2, 3])) {
    echo json_encode(['success' => false, 'error' => 'Opção de giro inválida.']);
    exit;
}

// 3. VALIDAR PERSONAGEM
$stmtCheck = $pdo->prepare("SELECT name FROM players WHERE id = ? AND account_id = ?");
$stmtCheck->execute([$charId, $_SESSION['account_id']]);
$charName = $stmtCheck->fetchColumn();

if (!$charName) {
    echo json_encode(['success' => false, 'error' => 'Personagem inválido. Selecione um personagem da sua conta.']);
    exit;
}

// 4. CARREGAR CONFIGURAÇÃO DINÂMICA
$config = $pdo->query("SELECT * FROM gacha_config WHERE id = 1")->fetch(PDO::FETCH_ASSOC);

// Define Quantidade e Custo
$spins = $config["opt{$optionIndex}_amount"];
$cost = $config["opt{$optionIndex}_cost"];
$seasonId = $config['current_season_id'] ?? 1;

// 5. VERIFICAR SALDO (post_points)
$stmtPoints = $pdo->prepare("SELECT post_points FROM accounts WHERE id = ?");
$stmtPoints->execute([$_SESSION['account_id']]);
$myPoints = $stmtPoints->fetchColumn();

if ($myPoints < $cost) {
    echo json_encode(['success' => false, 'error' => 'Saldo de pontos insuficiente.']);
    exit;
}

// 6. DEBITAR PONTOS (Usando Transação para segurança)
try {
    $pdo->beginTransaction();
    $pdo->prepare("UPDATE accounts SET post_points = post_points - ? WHERE id = ?")->execute([$cost, $_SESSION['account_id']]);
    $newPoints = $myPoints - $cost;

    // 7. REALIZAR OS GIROS
    $wonItems = [];

    for ($i = 0; $i < $spins; $i++) {
        $prize = spinGacha($pdo);
        
        if ($prize) {
            // Adiciona dados visuais para o front
            list($hex, $class) = getRarityColor($prize['rarity']);
            $prize['color_hex'] = $hex;
            $prize['color_class'] = $class;
            
            $wonItems[] = $prize;

            // A. Histórico
            $stmtHistory = $pdo->prepare("INSERT INTO gacha_history (account_id, player_name, item_name, rarity, season_id, item_id, item_count, cost_points, option_index) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmtHistory->execute([
                $_SESSION['account_id'], 
                $charName, 
                $prize['item_name'], 
                $prize['rarity'], 
                $seasonId,
                $prize['item_id'],
                $prize['count'],
                $cost / $spins,
                $optionIndex
            ]);

            // B. Entrega (Requer a tabela 'gacha_delivery')
            $count = $prize['count'] ?? 1; 
            $stmtDelivery = $pdo->prepare("INSERT INTO gacha_delivery (player_id, item_id, count, delivered) VALUES (?, ?, ?, 0)");
            $stmtDelivery->execute([$charId, $prize['item_id'], $count]);
        }
    }

    $pdo->commit();
    
    // 8. RETORNO DE SUCESSO
    echo json_encode([
        'success' => true,
        'new_points' => $newPoints,
        'results' => $wonItems
    ]);
    
} catch (Exception $e) {
    $pdo->rollBack();
    // 8. RETORNO DE ERRO
    // IMPORTANTE: Se a tabela gacha_delivery não existir, o erro será capturado aqui.
    echo json_encode(['success' => false, 'error' => 'Erro interno na transação: ' . $e->getMessage()]);
}
?>