<?php
// ==========================================================
// ARQUIVO: check_last_payment.php
// ATUALIZAÇÃO: Busca por ID específico da transação
// ==========================================================

session_start();
ini_set('display_errors', 0);
header('Content-Type: application/json');

require 'includes/conexao.php';

if (!isset($_SESSION['account_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Not logged']);
    exit;
}

$acc_id = $_SESSION['account_id'];
$tid = $_GET['tid'] ?? null; // Recebe o ID da transação via URL

try {
    if ($tid) {
        // MODO 1: Verificação Exata (Quando passamos o ID)
        $stmt = $pdo->prepare("
            SELECT status 
            FROM payments_history 
            WHERE transaction_id = ? AND account_id = ? 
            LIMIT 1
        ");
        $stmt->execute([$tid, $acc_id]);
    } else {
        // MODO 2: Fallback (Último pagamento em 15 min) - Caso o usuário perca o link
        $stmt = $pdo->prepare("
            SELECT status 
            FROM payments_history 
            WHERE account_id = ? AND date_processed > ? 
            ORDER BY id DESC LIMIT 1
        ");
        $stmt->execute([$acc_id, time() - 900]);
    }

    $last = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($last) {
        if ($last['status'] === 'approved') {
            echo json_encode(['status' => 'approved']);
        } else {
            echo json_encode(['status' => 'pending']);
        }
    } else {
        echo json_encode(['status' => 'not_found']);
    }

} catch (Exception $e) {
    echo json_encode(['status' => 'error']);
}
?>