<?php
// Simulação das variáveis de configuração
$siteConfig = [
    'server_name' => 'PokeServer',
    'color_header' => '#dc2626', // Vermelho Principal (Pokémon)
    'color_footer' => '#f8f9fa', // Fundo Claro
    'email_suporte' => 'suporte@pokeserver.com.br', // Seu e-mail de suporte
    'url_discord' => 'https://discord.gg/SEUCONVITEAQUI' // Link do seu Discord
];

// Requer o header (abre <html>, <head>, <body> e inclui o menu de navegação)
require_once('includes/header.php'); 
?>

<div class="container my-5">
    <h1 class="text-center mb-4 text-success"><i class="bi bi-headset-fill"></i> Fale Conosco</h1>
    <p class="text-center mb-5 lead text-muted fst-italic">Nossa equipe de suporte está pronta para ajudá-lo. Escolha o canal adequado para sua necessidade.</p>

    <div class="row text-center">
        
        <div class="col-md-4 mb-4">
            <div class="card h-100 shadow-lg border-success">
                <div class="card-header bg-success text-white h4 fw-bold">Suporte Técnico e Tickets</div>
                <div class="card-body">
                    <i class="bi bi-shield-lock-fill text-success" style="font-size: 3rem;"></i>
                    <h5 class="card-title mt-3">Problemas de Conta e Bugs</h5>
                    <p class="card-text text-muted">Use este canal para problemas técnicos no jogo, bugs graves, perda de itens por falha do servidor ou denúncias detalhadas de *cheaters*.</p>
                    
                    <a href="#" class="btn btn-success btn-lg disabled" aria-disabled="true">Abrir Ticket (Em Desenvolvimento)</a>
                    <small class="d-block mt-2 text-warning">Por enquanto, use o Discord ou E-mail para reportar.</small>
                </div>
            </div>
        </div>

        <div class="col-md-4 mb-4">
            <div class="card h-100 shadow-lg border-primary">
                <div class="card-header bg-primary text-white h4 fw-bold">Questões Administrativas</div>
                <div class="card-body">
                    <i class="bi bi-envelope-fill text-primary" style="font-size: 3rem;"></i>
                    <h5 class="card-title mt-3">Parcerias e Mídia</h5>
                    <p class="card-text text-muted">Este canal é destinado a contatos de imprensa, propostas de parceria, ou questões complexas que exijam a atenção da administração.</p>
                    
                    <a href="mailto:<?php echo $siteConfig['email_suporte']; ?>" class="btn btn-outline-primary btn-lg">Enviar E-mail</a>
                    <p class="mt-2 fw-bold text-dark"><?php echo $siteConfig['email_suporte']; ?></p>
                </div>
            </div>
        </div>

        <div class="col-md-4 mb-4">
            <div class="card h-100 shadow-lg border-info">
                <div class="card-header bg-info text-white h4 fw-bold">Comunidade e Ajuda Rápida</div>
                <div class="card-body">
                    <i class="bi bi-discord text-info" style="font-size: 3rem;"></i>
                    <h5 class="card-title mt-3">Dúvidas, Guias e Interação</h5>
                    <p class="card-text text-muted">A forma mais rápida de obter ajuda. Tire dúvidas sobre mecânicas de jogo, encontre grupos para caçar e interaja com a comunidade.</p>
                    
                    <a href="<?php echo $siteConfig['url_discord']; ?>" target="_blank" class="btn btn-info text-white btn-lg">Entrar no Discord</a>
                    <small class="d-block mt-2 text-success fw-bold">Suporte informal da Staff e da Comunidade.</small>
                </div>
            </div>
        </div>

    </div>
    
    <div class="alert alert-warning text-center mt-5 shadow">
        <h5 class="fw-bold text-danger">⚠️ Alerta de Segurança</h5>
        <p class="mb-0">A **Staff do PokeServer NUNCA** solicitará sua senha, PIN de conta ou qualquer informação sensível por E-mail, Discord ou qualquer outro canal de comunicação. Mantenha seus dados protegidos.</p>
    </div>
</div>

<?php 
// Requer o footer (inclui o rodapé, o aviso de cookies e fecha as tags <body> e <html>)
require_once('includes/footer.php'); 
?>