<?php
// downloads.php
$page_title = "Downloads";

// Verifica a conexão e inclui o header (ajuste os caminhos se necessário)
require_once 'includes/conexao.php'; // Certifique-se que este arquivo existe
include 'includes/header.php';

// Link configurado conforme seu pedido
$clientLink = "https://www.mediafire.com/file/pyet4y2grvy6t4i/Client_Relics.rar/file";

// Tenta pegar informações do servidor para exibir o IP (opcional)
$serverIp = "pokemonrelics.com"; // Valor padrão caso não ache no banco
if(isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT value FROM server_config WHERE config = 'ip' LIMIT 1");
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if($result) $serverIp = $result['value'];
    } catch(Exception $e) {}
}
?>

<style>
    /* Hero Section com Gradiente e Imagem de Fundo */
    .download-hero {
        background: linear-gradient(rgba(0,0,0,0.7), rgba(0,0,0,0.9)), url('images/bg-download.jpg');
        background-size: cover;
        background-position: center;
        border-radius: 20px;
        padding: 80px 20px;
        color: white;
        text-align: center;
        box-shadow: 0 15px 40px rgba(0,0,0,0.4);
        border: 1px solid rgba(255,255,255,0.1);
        margin-bottom: 50px;
        position: relative;
        overflow: hidden;
    }

    /* Efeito de brilho no fundo */
    .download-hero::after {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255,203,5,0.15) 0%, rgba(0,0,0,0) 70%);
        pointer-events: none;
    }

    /* Cards de Informação */
    .info-card {
        background: white;
        border-radius: 15px;
        border: none;
        box-shadow: 0 10px 30px rgba(0,0,0,0.05);
        height: 100%;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        overflow: hidden;
    }
    .info-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 35px rgba(0,0,0,0.1);
    }
    .card-header-custom {
        background: #f8f9fa;
        padding: 20px;
        border-bottom: 1px solid #eee;
        font-weight: 700;
        color: #2d3436;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    /* Botão de Download Principal */
    .btn-download-main {
        background: linear-gradient(45deg, #ffcb05, #f39c12);
        color: #000;
        font-weight: 800;
        font-family: 'Rajdhani', sans-serif;
        text-transform: uppercase;
        padding: 18px 50px;
        border-radius: 50px;
        font-size: 1.5rem;
        border: none;
        position: relative;
        z-index: 10;
        box-shadow: 0 0 20px rgba(255, 203, 5, 0.4);
        transition: all 0.3s;
        text-decoration: none;
        display: inline-block;
    }
    .btn-download-main:hover {
        transform: scale(1.05);
        box-shadow: 0 0 40px rgba(255, 203, 5, 0.6);
        color: #000;
    }
    .btn-download-main i {
        animation: bounce 2s infinite;
    }

    /* Tabela de Requisitos */
    .req-table { width: 100%; }
    .req-table td { padding: 12px 15px; border-bottom: 1px solid #f1f2f6; font-size: 0.95rem; }
    .req-table tr:last-child td { border-bottom: none; }
    .req-label { font-weight: 600; color: #636e72; width: 40%; }

    /* Passos de Instalação */
    .install-step {
        display: flex;
        margin-bottom: 20px;
        align-items: flex-start;
    }
    .step-icon {
        background: #e17055;
        color: white;
        width: 35px;
        height: 35px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        margin-right: 15px;
        flex-shrink: 0;
    }
    .bg-green { background: #00b894 !important; }
    .bg-blue { background: #0984e3 !important; }

    @keyframes bounce {
        0%, 20%, 50%, 80%, 100% {transform: translateY(0);}
        40% {transform: translateY(-5px);}
        60% {transform: translateY(-3px);}
    }
</style>

<div class="container my-5">

    <div class="download-hero">
        <div class="position-relative z-2">
            <h1 class="display-4 fw-bold mb-3" style="font-family: 'Rajdhani', sans-serif;">BAIXAR CLIENTE OFICIAL</h1>
            <p class="lead mb-4 text-white-50">Versão atualizada • Otimizado • Anti-Hack Incluso</p>
            
            <a href="<?php echo $clientLink; ?>" target="_blank" class="btn-download-main">
                <i class="fas fa-cloud-download-alt me-3"></i> DOWNLOAD DIRETO
            </a>
            
            <div class="mt-4 d-flex justify-content-center gap-4 text-white-50 small">
                <span><i class="fab fa-windows me-1"></i> Windows</span>
                <span><i class="fas fa-shield-alt me-1"></i> Verificado</span>
                <span><i class="fas fa-file-archive me-1"></i> Formato .RAR</span>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-lg-6">
            <div class="info-card">
                <div class="card-header-custom">
                    <i class="fas fa-laptop-code text-primary fs-4"></i>
                    <span>Requisitos Mínimos</span>
                </div>
                <div class="p-3">
                    <table class="req-table">
                        <tr>
                            <td class="req-label">Sistema Operacional</td>
                            <td>Windows 7 / 8 / 10 / 11</td>
                        </tr>
                        <tr>
                            <td class="req-label">Processador</td>
                            <td>Intel Core i3 (ou equivalente)</td>
                        </tr>
                        <tr>
                            <td class="req-label">Memória RAM</td>
                            <td>4 GB ou superior</td>
                        </tr>
                        <tr>
                            <td class="req-label">Placa de Vídeo</td>
                            <td>Suporte a DirectX 9.0c</td>
                        </tr>
                        <tr>
                            <td class="req-label">Espaço em Disco</td>
                            <td>~500 MB Livre</td>
                        </tr>
                        <tr>
                            <td class="req-label">Programas Extras</td>
                            <td><a href="https://www.win-rar.com/download.html" target="_blank" class="text-decoration-none">WinRAR</a> (para extrair)</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="info-card">
                <div class="card-header-custom">
                    <i class="fas fa-rocket text-success fs-4"></i>
                    <span>Como Começar a Jogar</span>
                </div>
                <div class="p-4">
                    <div class="install-step">
                        <div class="step-icon bg-blue">1</div>
                        <div>
                            <strong>Faça o Download</strong>
                            <p class="text-muted small m-0">Clique no botão amarelo acima e baixe o arquivo <code>Client Relics.rar</code>.</p>
                        </div>
                    </div>

                    <div class="install-step">
                        <div class="step-icon bg-green">2</div>
                        <div>
                            <strong>Extraia o Arquivo</strong>
                            <p class="text-muted small m-0">Use o WinRAR para extrair a pasta na sua Área de Trabalho.</p>
                        </div>
                    </div>

                    <div class="install-step">
                        <div class="step-icon">3</div>
                        <div>
                            <strong>Crie sua Conta</strong>
                            <p class="text-muted small m-0">Se ainda não tem, <a href="register.php" class="fw-bold">crie sua conta aqui</a> no site.</p>
                        </div>
                    </div>

                    <div class="alert alert-warning d-flex align-items-center mt-3 mb-0 border-0" role="alert">
                        <i class="fas fa-exclamation-triangle fs-4 me-3"></i>
                        <div>
                            <small class="fw-bold d-block">Problemas ao abrir?</small>
                            <small>Execute o jogo como <strong>Administrador</strong> e adicione nas exceções do antivírus.</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="text-center mt-5 text-muted">
        <small>Caso precise do IP Changer (Geralmente não é necessário):</small><br>
        <code class="fs-6 text-dark fw-bold bg-white px-3 py-1 rounded border"><?php echo htmlspecialchars($serverIp); ?></code>
    </div>

</div>

<?php include 'includes/footer.php'; ?>