<?php
// guild_actions.php
// ATIVAR MODO DE DEPURAÇÃO DE ERROS
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require_once 'includes/conexao.php'; // Certifique-se que o caminho está certo

// Define cabeçalho JSON
header('Content-Type: application/json; charset=utf-8');

// Configurações da Guilda
$guildConfig = [
    'level_req' => 50,       // Level mínimo
    'price_req' => 50000,    // Preço (50k)
    'logo_dir'  => 'images/guilds/',
    'max_size'  => 2 * 1024 * 1024 // 2MB
];

// Validação Básica da Requisição
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['action'])) {
    echo json_encode(['status' => 'error', 'message' => 'Requisição inválida.']);
    exit;
}

if (!isset($_SESSION['account_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Sessão expirada. Faça login novamente.']);
    exit;
}

$action = $_POST['action'];
$accountId = $_SESSION['account_id'];

try {
    // Inicia Transação SQL
    $pdo->beginTransaction();

    // ===================================================================================
    // AÇÃO: CRIAR GUILDA
    // ===================================================================================
    if ($action === 'create_guild') {
        $name     = trim($_POST['guild_name']);
        $leaderId = (int)$_POST['leader_id'];
        $motd     = trim($_POST['motd']);

        // 1. Validar Personagem
        $stmt = $pdo->prepare("SELECT id, name, level, balance FROM players WHERE id = ? AND account_id = ?");
        $stmt->execute([$leaderId, $accountId]);
        $player = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$player) throw new Exception("Personagem inválido ou não pertence à sua conta.");
        if ($player['level'] < $guildConfig['level_req']) throw new Exception("Level insuficiente. Mínimo: " . $guildConfig['level_req']);
        if ($player['balance'] < $guildConfig['price_req']) throw new Exception("Saldo insuficiente. Necessário: " . number_format($guildConfig['price_req']));

        // 2. Validar Nome
        if (strlen($name) < 3 || strlen($name) > 30) throw new Exception("Nome deve ter entre 3 e 30 caracteres.");
        
        $checkName = $pdo->prepare("SELECT id FROM guilds WHERE name = ?");
        $checkName->execute([$name]);
        if ($checkName->rowCount() > 0) throw new Exception("Já existe uma guilda com este nome.");

        $checkMember = $pdo->prepare("SELECT player_id FROM guild_membership WHERE player_id = ?");
        $checkMember->execute([$leaderId]);
        if ($checkMember->rowCount() > 0) throw new Exception("Este personagem já está em uma guilda.");

        // 3. Upload Logo
        $logoName = 'default.png';
        if (isset($_FILES['guild_logo']) && $_FILES['guild_logo']['error'] === 0) {
            $file = $_FILES['guild_logo'];
            $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
            if (!in_array($ext, ['jpg', 'jpeg', 'png', 'gif'])) throw new Exception("Formato de imagem inválido.");
            if ($file['size'] > $guildConfig['max_size']) throw new Exception("Imagem muito grande (Max 2MB).");
            
            if (!is_dir($guildConfig['logo_dir'])) mkdir($guildConfig['logo_dir'], 0777, true);
            
            $newName = md5(time() . $name) . '.' . $ext;
            if (move_uploaded_file($file['tmp_name'], $guildConfig['logo_dir'] . $newName)) {
                $logoName = $newName;
            }
        }

        // 4. Cobrança e Criação
        $pdo->prepare("UPDATE players SET balance = balance - ? WHERE id = ?")->execute([$guildConfig['price_req'], $leaderId]);
        
        // Inserção na tabela guilds
        $stmtInsert = $pdo->prepare("INSERT INTO guilds (name, ownerid, creationdata, motd, logo_gfx, description, rules) VALUES (?, ?, ?, ?, ?, '', '')");
        $stmtInsert->execute([$name, $leaderId, time(), $motd, $logoName]);
        $guildId = $pdo->lastInsertId();

        // 5. Configurar Rank de Líder
        // Tenta pegar o rank criado pelo Trigger do banco
        $stmtRank = $pdo->prepare("SELECT id FROM guild_ranks WHERE guild_id = ? AND level = 3 LIMIT 1");
        $stmtRank->execute([$guildId]);
        $leaderRankId = $stmtRank->fetchColumn();

        // Se o trigger falhou ou não existe, cria manualmente
        if (!$leaderRankId) {
            $pdo->prepare("INSERT INTO guild_ranks (name, level, guild_id) VALUES ('Líder', 3, ?)")->execute([$guildId]);
            $leaderRankId = $pdo->lastInsertId();
            $pdo->prepare("INSERT INTO guild_ranks (name, level, guild_id) VALUES ('Vice-Líder', 2, ?)")->execute([$guildId]);
            $pdo->prepare("INSERT INTO guild_ranks (name, level, guild_id) VALUES ('Membro', 1, ?)")->execute([$guildId]);
        }

        // Adiciona Líder na Membership
        $pdo->prepare("INSERT INTO guild_membership (player_id, guild_id, rank_id, nick) VALUES (?, ?, ?, 'Líder')")
            ->execute([$leaderId, $guildId, $leaderRankId]);

        // Atualiza tabela players (Opcional, depende do servidor)
        // $pdo->prepare("UPDATE players SET rank_id = ?, guildnick = 'Líder' WHERE id = ?")->execute([$leaderRankId, $leaderId]);

        $response = ['status' => 'success', 'message' => 'Guilda criada com sucesso!', 'redirect' => 'guilds.php?view=' . $guildId];
    }

    // ===================================================================================
    // AÇÕES DE GERENCIAMENTO (CONVIDAR, ACEITAR, KICKAR)
    // ===================================================================================
    else {
        $guildId   = isset($_POST['guild_id']) ? (int)$_POST['guild_id'] : 0;
        $managerId = isset($_POST['manager_id']) ? (int)$_POST['manager_id'] : 0;
        
        // Verifica permissão do Manager (Líder ou Vice)
        $stmtPerm = $pdo->prepare("
            SELECT g.ownerid, gr.level, gr.name as rank_name 
            FROM guilds g 
            JOIN guild_membership gm ON g.id = gm.guild_id 
            JOIN guild_ranks gr ON gm.rank_id = gr.id 
            WHERE g.id = ? AND gm.player_id = ?
        ");
        $stmtPerm->execute([$guildId, $managerId]);
        $mgrInfo = $stmtPerm->fetch(PDO::FETCH_ASSOC);

        // Verifica conta
        $checkAcc = $pdo->prepare("SELECT account_id FROM players WHERE id = ?");
        $checkAcc->execute([$managerId]);
        if ($checkAcc->fetchColumn() != $accountId) throw new Exception("Validação de segurança falhou.");

        if (!$mgrInfo) throw new Exception("Você não tem permissão para gerenciar esta guilda.");
        
        $mgrLevel = (int)$mgrInfo['level']; // 3=Líder, 2=Vice

        switch ($action) {
            case 'invite_player':
                if ($mgrLevel < 2) throw new Exception("Apenas Líderes e Vices podem convidar.");
                $targetName = trim($_POST['player_name']);
                
                // Busca ID do player pelo nome
                $stmtT = $pdo->prepare("SELECT id FROM players WHERE name = ?");
                $stmtT->execute([$targetName]);
                $targetId = $stmtT->fetchColumn();

                if (!$targetId) throw new Exception("Jogador '$targetName' não encontrado.");
                
                // Verifica se já tem guilda
                $chkG = $pdo->prepare("SELECT player_id FROM guild_membership WHERE player_id = ?");
                $chkG->execute([$targetId]);
                if ($chkG->rowCount() > 0) throw new Exception("Este jogador já possui uma guilda.");

                // Verifica se já foi convidado
                $chkI = $pdo->prepare("SELECT player_id FROM guild_invites WHERE player_id = ? AND guild_id = ?");
                $chkI->execute([$targetId, $guildId]);
                if ($chkI->rowCount() > 0) throw new Exception("Jogador já possui um convite pendente.");

                $pdo->prepare("INSERT INTO guild_invites (player_id, guild_id) VALUES (?, ?)")->execute([$targetId, $guildId]);
                $response = ['status' => 'success', 'message' => "Convite enviado para $targetName!"];
                break;

            case 'accept_invite':
                // Nota: Nesta lógica, o Lider/Vice aceita o membro que está na lista de convites
                if ($mgrLevel < 2) throw new Exception("Permissão insuficiente.");
                $targetId = (int)$_POST['target_id'];

                // Pega Rank Inicial (Level 1)
                $rStmt = $pdo->prepare("SELECT id FROM guild_ranks WHERE guild_id = ? AND level = 1 LIMIT 1");
                $rStmt->execute([$guildId]);
                $rankId = $rStmt->fetchColumn();

                if (!$rankId) throw new Exception("Erro interno: Rank de membro não encontrado.");

                $pdo->prepare("DELETE FROM guild_invites WHERE guild_id = ? AND player_id = ?")->execute([$guildId, $targetId]);
                $pdo->prepare("INSERT INTO guild_membership (player_id, guild_id, rank_id, nick) VALUES (?, ?, ?, 'Recruta')")->execute([$targetId, $guildId, $rankId]);
                
                // $pdo->prepare("UPDATE players SET rank_id = ?, guildnick = 'Recruta' WHERE id = ?")->execute([$rankId, $targetId]);

                $response = ['status' => 'success', 'message' => "Jogador adicionado à guilda!"];
                break;

            case 'reject_invite':
                if ($mgrLevel < 2) throw new Exception("Permissão insuficiente.");
                $targetId = (int)$_POST['target_id'];
                $pdo->prepare("DELETE FROM guild_invites WHERE guild_id = ? AND player_id = ?")->execute([$guildId, $targetId]);
                $response = ['status' => 'success', 'message' => "Convite cancelado."];
                break;

            case 'remove_member':
                if ($mgrLevel < 2) throw new Exception("Permissão insuficiente.");
                $targetId = (int)$_POST['target_id'];

                // Checa hierarquia
                $tStmt = $pdo->prepare("SELECT gm.player_id, gr.level FROM guild_membership gm JOIN guild_ranks gr ON gm.rank_id = gr.id WHERE gm.player_id = ? AND gm.guild_id = ?");
                $tStmt->execute([$targetId, $guildId]);
                $targetInfo = $tStmt->fetch(PDO::FETCH_ASSOC);

                if ($targetInfo) {
                    if ($targetInfo['level'] >= $mgrLevel && $targetId != $managerId) throw new Exception("Você não pode remover alguém de cargo superior ou igual.");
                }

                $pdo->prepare("DELETE FROM guild_membership WHERE guild_id = ? AND player_id = ?")->execute([$guildId, $targetId]);
                // $pdo->prepare("UPDATE players SET rank_id = 0, guildnick = '' WHERE id = ?")->execute([$targetId]);
                
                $response = ['status' => 'success', 'message' => "Membro expulso da guilda."];
                break;

            case 'edit_info':
                if ($mgrLevel < 3) throw new Exception("Apenas o Líder pode editar informações.");
                
                $motd = trim($_POST['motd']);
                $desc = trim($_POST['description']);
                $rules = trim($_POST['rules']);

                $sql = "UPDATE guilds SET motd = ?, description = ?, rules = ?";
                $params = [$motd, $desc, $rules];

                if (isset($_FILES['new_logo']) && $_FILES['new_logo']['error'] === 0) {
                     $file = $_FILES['new_logo'];
                     $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
                     if (in_array($ext, ['jpg', 'png', 'gif']) && $file['size'] <= $guildConfig['max_size']) {
                         $newName = md5(time().$guildId) . '.' . $ext;
                         move_uploaded_file($file['tmp_name'], $guildConfig['logo_dir'] . $newName);
                         $sql .= ", logo_gfx = ?";
                         $params[] = $newName;
                     }
                }

                $sql .= " WHERE id = ?";
                $params[] = $guildId;
                
                $pdo->prepare($sql)->execute($params);
                $response = ['status' => 'success', 'message' => "Informações salvas com sucesso."];
                break;

            case 'delete_guild':
                if ($mgrLevel < 3) throw new Exception("Apenas o Líder pode apagar a guilda.");
                $pdo->prepare("DELETE FROM guilds WHERE id = ?")->execute([$guildId]);
                // Triggers devem limpar o resto (ranks, membership)
                $response = ['status' => 'success', 'message' => "Guilda deletada.", 'redirect' => 'guilds.php'];
                break;

            default:
                throw new Exception("Ação desconhecida.");
        }
    }

    $pdo->commit();
    echo json_encode($response);

} catch (Exception $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    // Retorna erro em formato JSON
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>