<?php
// includes/admin_header.php

// Blinda sessão dupla
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if(!isset($siteConfig)) { $siteConfig = ['server_name' => 'Admin Panel', 'color_header' => '#0f172a']; }

// Variáveis de Tickets
$pendingTicketsCount = $pendingTicketsCount ?? 0;
$ticketsNeedingReply = $ticketsNeedingReply ?? 0;

// Badge lateral
$pendingBadge = '';
if ($pendingTicketsCount > 0) {
    $pendingBadge = '<span class="badge bg-danger ms-auto rounded-pill shadow-sm" style="font-size:0.7rem;">' . $pendingTicketsCount . '</span>';
}

// Notificação Urgente
$urgentNotification = '';
if ($ticketsNeedingReply > 0) {
    $urgentNotification = '
        <div class="alert alert-danger p-2 mb-0 d-flex justify-content-center align-items-center rounded-0 shadow fw-bold border-0" role="alert" style="background: linear-gradient(90deg, #ef4444 0%, #dc2626 100%); color: white;">
            <i class="fas fa-bell me-2 fa-shake"></i> 
            <span>ATENÇÃO: ' . $ticketsNeedingReply . ' Ticket(s) com resposta do jogador!</span> 
            <a href="tickets.php" class="btn btn-sm btn-light text-danger fw-bold ms-3 rounded-pill px-3">VER AGORA</a>
        </div>
    ';
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow"> <meta name="description" content="Painel Administrativo - Gestão completa do servidor.">
    <meta name="author" content="Admin Team">
    
    <title><?php echo isset($page_title) ? $page_title . ' | Admin' : 'Admin Panel'; ?></title>
    
    <link rel="icon" type="image/png" href="../images/iconrelics.png">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Rajdhani:wght@400;600;700&family=Segoe+UI:wght@400;600&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --sidebar-bg: #0f172a;
            --sidebar-hover: #1e293b;
            --text-main: #f8fafc;
            --text-muted: #94a3b8;
            --accent: #3b82f6;
        }

        body { 
            font-family: 'Segoe UI', sans-serif; 
            background-color: #020617; /* Fundo global escuro */
            color: var(--text-main);
        }
        
        /* SIDEBAR */
        .sidebar {
            background-color: var(--sidebar-bg);
            min-height: 100vh;
            border-right: 1px solid rgba(255,255,255,0.05);
            box-shadow: 5px 0 15px rgba(0,0,0,0.2);
            z-index: 1000;
        }
        
        /* Logo Area */
        .brand-area {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.05);
            background: rgba(0,0,0,0.2);
        }
        .brand-logo {
            max-width: 140px;
            height: auto;
            transition: transform 0.3s;
        }
        .brand-logo:hover { transform: scale(1.05); }

        /* Links */
        .sidebar .nav-link {
            color: var(--text-muted);
            font-weight: 600;
            padding: 12px 20px;
            border-left: 3px solid transparent;
            transition: all 0.2s;
            display: flex;
            align-items: center;
        }
        .sidebar .nav-link:hover { 
            color: #fff; 
            background-color: var(--sidebar-hover); 
            padding-left: 25px; /* Efeito de deslize */
        }
        .sidebar .nav-link.active {
            color: #fff;
            background: linear-gradient(90deg, rgba(59, 130, 246, 0.1) 0%, transparent 100%);
            border-left-color: var(--accent);
        }
        .sidebar .nav-link i { 
            width: 25px; text-align: center; margin-right: 10px; 
            transition: transform 0.2s;
        }
        .sidebar .nav-link:hover i { transform: scale(1.2); color: var(--accent); }

        /* Heading */
        .sidebar-heading { 
            color: #475569; 
            font-size: 0.7rem; 
            text-transform: uppercase; 
            letter-spacing: 1.5px; 
            font-weight: 800;
            margin-top: 25px; 
            margin-bottom: 10px; 
            padding-left: 20px; 
        }
        
        /* Navbar Mobile */
        .navbar-top { background: var(--sidebar-bg); border-bottom: 1px solid rgba(255,255,255,0.1); }
        .navbar-toggler { border-color: rgba(255,255,255,0.2); }
        .navbar-toggler-icon { filter: invert(1); }

        /* Content Area */
        .admin-content { padding: 30px; }
    </style>
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <nav id="sidebarMenu" class="col-md-3 col-lg-2 d-md-block sidebar collapse p-0">
            
            <div class="brand-area">
                <img src="../images/logorelics.png" alt="Logo" class="brand-logo mb-2" onerror="this.src='../images/iconrelics.png'">
                <div class="small text-muted fw-bold text-uppercase ls-1">Painel Admin</div>
            </div>

            <div class="position-sticky pt-3 pb-5">
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($page_title == 'Dashboard Financeiro') ? 'active' : ''; ?>" href="index.php">
                            <i class="fas fa-chart-pie text-info"></i> Visão Geral
                        </a>
                    </li>
                    
                    <div class="sidebar-heading">Gestão</div>
                    
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($page_title == 'Gestão de Jogadores') ? 'active' : ''; ?>" href="players.php">
                            <i class="fas fa-users"></i> Jogadores
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($page_title == 'Gestão Avançada do Shop') ? 'active' : ''; ?>" href="shop.php">
                            <i class="fas fa-store"></i> Loja & Itens
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($page_title == 'Configuração do Gacha') ? 'active' : ''; ?>" href="admin_gacha">
                            <i class="fas fa-dice text-warning"></i> Gacha System
                        </a>
                    </li>

                    <div class="sidebar-heading">Conteúdo</div>
                    
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($page_title == 'Wiki Editor') ? 'active' : ''; ?>" href="wiki.php">
                            <i class="fas fa-book"></i> Wiki
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($page_title == 'Gerenciar Notícias') ? 'active' : ''; ?>" href="news.php">
                            <i class="fas fa-newspaper"></i> Notícias
                        </a>
                    </li>
                    
                    <div class="sidebar-heading">Suporte</div>

                    <li class="nav-item">
                        <a class="nav-link <?php echo ($page_title == 'Tickets de Suporte') ? 'active' : ''; ?>" href="tickets.php">
                            <i class="fas fa-headset"></i> Tickets
                            <?php echo $pendingBadge; ?>
                        </a>
                    </li>

                    <div class="sidebar-heading">Sistema</div>
                    
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($page_title == 'Config MP') ? 'active' : ''; ?>" href="config_mp.php">
                            <i class="fas fa-credit-card"></i> Mercado Pago
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($page_title == 'Config Lua') ? 'active' : ''; ?>" href="config-lua.php">
                            <i class="fas fa-file-code"></i> Config.lua
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($page_title == 'Importador Houses/Map') ? 'active' : ''; ?>" href="houses_importer.php">
                            <i class="fas fa-home"></i> Importador Map
                        </a>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($page_title == 'Quests/Insignas') ? 'active' : ''; ?>" href="manage_content.php">
                            <i class="fas fa-home"></i> Quests/Insignas
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($page_title == 'Logs & Auditoria Financeira') ? 'active' : ''; ?>" href="logs.php">
                            <i class="fas fa-list-alt"></i> Logs & Auditoria
                        </a>
                    </li>

                    <li class="nav-item mt-4 px-3">
                        <a class="btn btn-outline-secondary w-100 fw-bold d-flex align-items-center justify-content-center" href="../"> 
                            <i class="fas fa-external-link-alt me-2"></i> Ver Site
                        </a>
                    </li>
                    <li class="nav-item mt-2 px-3">
                        <a class="btn btn-danger w-100 fw-bold d-flex align-items-center justify-content-center" href="../logout.php">
                            <i class="fas fa-power-off me-2"></i> Sair
                        </a>
                    </li>
                </ul>
            </div>
        </nav>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-0">
            <?php echo $urgentNotification; ?>
            
            <nav class="navbar navbar-top d-md-none px-3 text-white">
                <div class="d-flex align-items-center">
                    <img src="../images/iconrelics.png" width="30" class="me-2">
                    <span class="fw-bold">Admin Panel</span>
                </div>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#sidebarMenu">
                    <span class="navbar-toggler-icon"></span>
                </button>
            </nav>
            
            <div class="admin-content">