<?php
// Arquivo: /var/www/html/includes/conexao.php

// ====================================================================
// ÁREA DE CONFIGURAÇÃO RÁPIDA (EDITE AQUI SE PRECISAR)
// ====================================================================

// Onde está a pasta do seu servidor (TFS/OTX) no Ubuntu?
// Exemplos comuns: '/home/ubuntu/server/' ou '/home/otsmanager/server/'
// IMPORTANTE: Deve ter a barra '/' no final e o arquivo config.lua deve estar dentro desta pasta.
$caminho_servidor_linux = '/home/ubuntu/server/'; 

// Dados do Banco de Dados
$sql_host = 'localhost';
$sql_name = 'meusitenoarbr_poketibia';
$sql_user = 'meusitenoarbr_poketibia';           // Usuário que criamos no MySQL
$sql_pass = 'meusitenoarbr_poketibia'; // Sua senha

// ====================================================================
// 1. CARREGAMENTO DE CREDENCIAIS
// ====================================================================

// Tenta carregar config.php da raiz se existir (padrão Znote)
$configFile = __DIR__ . '/../config.php';

if (file_exists($configFile)) {
    include($configFile);
    // Se existir config.php, usa as variáveis de lá, senão usa as do topo deste arquivo
    $host = $config['sqlHost'] ?? $sql_host;
    $db   = $config['sqlDatabase'] ?? $sql_name;
    $user = $config['sqlUser'] ?? $sql_user;
    $pass = $config['sqlPassword'] ?? $sql_pass;
} else {
    // FALLBACK: Usa as variáveis definidas no topo
    $host = $sql_host;
    $db   = $sql_name;
    $user = $sql_user;
    $pass = $sql_pass;
}

// ====================================================================
// 2. CONFIGURAÇÃO GERAL DO ZNOTE (ADAPTADO PARA LINUX)
// ====================================================================
if (!isset($config)) {
    $config = array(
        'log_ip' => false,
        'allowSubPages' => true,
        'TFSVersion' => 'TFS_10',
        'session_prefix' => 'znote_',
        
        // --- CONFIGURAÇÃO CRÍTICA PARA LINUX ---
        'server_path' => $caminho_servidor_linux,
        // ---------------------------------------
        
        // Repassando as credenciais para o array do Znote
        'sqlType' => 'mysql',
        'sqlHost' => $host,
        'sqlUser' => $user,
        'sqlPassword' => $pass,
        'sqlDatabase' => $db,

        // Cidades (Map Editor)
        'towns' => array(
            34 => 'Saffron', 35 => 'Cerulean', 36 => 'Lavender', 37 => 'Fuchsia',
            38 => 'Celadon', 39 => 'Viridian', 40 => 'Vermilion', 41 => 'Pewter',
            43 => 'Cinnabar', 44 => 'Snow', 15 => 'Eirian'
        ),

        // Configurações de Leilão de Casas
        'houseConfig' => array(
            'HouseListDefaultTown' => 34,
            'minimumBidSQM' => 200,
            'auctionPeriod' => 60 * 60 * 24 * 3, // 3 dias
            'housesPerPlayer' => 1,
            'requirePremium' => true,
            'levelToBuyHouse' => 50,
        ),

        // Configurações Padrão de Segurança
        'use_captcha' => false,
        'paypal' => ['enabled' => false],
        'ip_security' => [
            'time_period' => 10, 
            'max_activity' => 60, 
            'max_account' => 10, 
            'max_character' => 5, 
            'max_post' => 50
        ],
        'flush_ip_logs' => false,
    );
}

// ====================================================================
// 3. CONEXÃO PDO (BANCO DE DADOS)
// ====================================================================
$charset = 'utf8mb4';
$dsn = "mysql:host=$host;dbname=$db;charset=$charset";

$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
    PDO::ATTR_PERSISTENT         => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    // Log de erro estilizado
    die("<div style='padding:20px; color:white; background-color:#ef4444; border-radius:5px; font-family:sans-serif;'>
            <strong>Erro de Conexão:</strong> Não foi possível conectar ao banco de dados <b>$db</b>.<br>
            <small>Verifique se o usuário '$user' existe e se a senha está correta no arquivo conexao.php.</small>
        </div>");
}

// ====================================================================
// 4. CONFIGURAÇÕES VISUAIS DO SITE (CARREGA DO BANCO)
// ====================================================================
$siteConfig = false;

try {
    // Verifica se a tabela existe antes de consultar
    $checkTable = $pdo->query("SHOW TABLES LIKE 'site_config'");
    
    if($checkTable->rowCount() > 0) {
        $queryConfig = $pdo->query("SELECT * FROM site_config WHERE id = 1 LIMIT 1");
        $siteConfig = $queryConfig->fetch();
    }
} catch (Exception $e) {
    $siteConfig = false;
}

// Valores Padrão (Tema Pokémon) se não houver no banco ou der erro
if(!$siteConfig) {
    $siteConfig = [
        'server_name'      => 'Pokemon Relics',
        'meta_description' => 'O melhor servidor de Poketibia.',
        'color_header'     => '#dc2626', // Vermelho
        'color_footer'     => '#1f2937', // Cinza
        'color_hero_start' => '#ef4444',
        'color_hero_end'   => '#f59e0b'
    ];
}

// ====================================================================
// 5. FUNÇÕES GLOBAIS ÚTEIS
// ====================================================================

// Conta players online (compatível com tfs antigo e novo)
function getOnlinePlayers($pdo) {
    try {
        // Tenta tabela moderna (memória)
        $stmt = $pdo->query("SELECT count(*) FROM players_online");
        return $stmt->fetchColumn(); 
    } catch (Exception $e) {
        // Fallback para tabela players
        try {
            $stmt = $pdo->query("SELECT count(*) FROM players WHERE online > 0");
            return $stmt->fetchColumn();
        } catch (Exception $ex) {
            return 0;
        }
    }
}

// Formata dinheiro (k, kk)
function formatMoney($number) {
    if ($number >= 1000000) return number_format($number / 1000000, 1) . 'kk';
    if ($number >= 1000) return number_format($number / 1000, 1) . 'k';
    return number_format($number, 0, ',', '.');
}

// Limpa inputs (Segurança básica contra XSS)
function sanitize($input) {
    return htmlspecialchars(strip_tags(trim($input)), ENT_QUOTES, 'UTF-8');
}
?>