<style>
    /* --- FOOTER THEME: Cyber Dark --- */
    .footer-custom {
        background: linear-gradient(to bottom, #0f172a 0%, #020617 100%);
        color: #ffffff;
        border-top: 1px solid rgba(255, 255, 255, 0.1);
        position: relative;
        padding-top: 60px;
        padding-bottom: 30px;
        margin-top: auto; /* Garante que o footer vá para baixo */
    }

    /* Efeito de luz no topo */
    .footer-custom::before {
        content: '';
        position: absolute;
        top: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 60%;
        height: 1px;
        background: linear-gradient(90deg, transparent, <?php echo $siteConfig['color_header'] ?? '#3b82f6'; ?>, transparent);
        box-shadow: 0 0 15px <?php echo $siteConfig['color_header'] ?? '#3b82f6'; ?>;
    }

    .footer-title {
        font-family: 'Rajdhani', sans-serif;
        font-weight: 800;
        font-size: 2rem;
        text-transform: uppercase;
        color: #fff;
        text-shadow: 0 0 20px rgba(255, 255, 255, 0.2);
        margin-bottom: 20px;
        letter-spacing: 2px;
    }

    /* Links */
    .footer-links {
        padding: 0;
        list-style: none;
        display: flex;
        justify-content: center;
        flex-wrap: wrap;
        gap: 20px;
        margin-bottom: 30px;
    }

    .footer-links a {
        color: rgba(255, 255, 255, 0.7);
        text-decoration: none;
        font-weight: 600;
        font-size: 1rem;
        text-transform: uppercase;
        transition: all 0.3s ease;
        position: relative;
        padding: 5px 10px;
    }

    .footer-links a::after {
        content: '';
        position: absolute;
        width: 0;
        height: 2px;
        bottom: 0;
        left: 50%;
        background-color: <?php echo $siteConfig['color_header'] ?? '#3b82f6'; ?>;
        transition: all 0.3s ease;
        transform: translateX(-50%);
    }

    .footer-links a:hover {
        color: #fff;
        text-shadow: 0 0 10px <?php echo $siteConfig['color_header'] ?? '#3b82f6'; ?>;
    }

    .footer-links a:hover::after {
        width: 100%;
    }

    /* Textos Gerais */
    .text-copyright {
        font-size: 0.9rem;
        color: rgba(255, 255, 255, 0.9);
        font-weight: 500;
    }

    .developer-credit {
        font-size: 0.8rem;
        color: rgba(255, 255, 255, 0.6);
        margin-top: 5px;
    }
    .developer-credit a {
        color: #fff;
        text-decoration: none;
        border-bottom: 1px dotted rgba(255,255,255,0.5);
    }

    /* Disclaimer Box */
    .disclaimer-box {
        margin-top: 40px;
        padding-top: 20px;
        border-top: 1px solid rgba(255, 255, 255, 0.05);
        font-size: 0.75rem;
        color: rgba(255, 255, 255, 0.5); /* Branco opaco para não ofuscar */
        line-height: 1.6;
        max-width: 800px;
        margin-left: auto;
        margin-right: auto;
    }

    /* --- COOKIE BANNER: Glassmorphism --- */
    .cookie-banner {
        position: fixed;
        bottom: 20px;
        left: 50%;
        transform: translateX(-50%);
        width: 90%;
        max-width: 600px;
        
        /* Efeito de Vidro */
        background: rgba(15, 23, 42, 0.85);
        backdrop-filter: blur(12px);
        -webkit-backdrop-filter: blur(12px);
        
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 16px;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5);
        
        padding: 20px;
        z-index: 9999;
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
        gap: 15px;
    }

    @media (min-width: 768px) {
        .cookie-banner {
            flex-direction: row;
            text-align: left;
            justify-content: space-between;
        }
    }

    .cookie-text {
        color: #e2e8f0;
        font-size: 0.9rem;
        margin: 0;
    }

    .btn-cookie {
        background: <?php echo $siteConfig['color_header'] ?? '#3b82f6'; ?>;
        color: white;
        font-weight: bold;
        border: none;
        padding: 10px 25px;
        border-radius: 50px;
        white-space: nowrap;
        box-shadow: 0 0 15px rgba(59, 130, 246, 0.4);
        transition: 0.3s;
    }
    .btn-cookie:hover {
        background: #fff;
        color: #000;
        transform: scale(1.05);
    }
</style>

<footer class="footer-custom text-center">
    <div class="container">
        <div class="row">
            <div class="col-12"> 
                <h5 class="footer-title">
                    <i class="fas fa-gamepad me-2 text-primary"></i> 
                    <?php echo $siteConfig['server_name'] ?? 'PokeServer'; ?>
                </h5>

                <ul class="footer-links">
                    <li><a href="politicas.php">Privacidade</a></li>
                    <li><a href="termos.php">Termos de Uso</a></li>
                    <li><a href="regras.php">Regras</a></li>
                    <li><a href="downloads.php">Download</a></li>
                    <li><a href="contato.php">Suporte</a></li>
                </ul>

                <p class="text-copyright mb-1">
                    &copy; <?php echo date('Y'); ?> <strong><?php echo $siteConfig['server_name'] ?? 'PokeServer'; ?></strong>. Todos os direitos reservados.
                </p>

                <div class="developer-credit">
                    Desenvolvido por <a href="http://meusitenoar.com.br" target="_blank" rel="noopener">Meusitenoar.com.br</a>
                </div>

                <div class="disclaimer-box">
                    <p class="mb-1">Community Pokémon Online - PokeTibia BRAZIL fan site.</p>
                    <p class="mb-0">
                        Pokémon Copyright &copy; 1995 - <?php echo date('Y'); ?> Nintendo/Creatures Inc./GAME FREAK Inc.<br>
                        Pokémon and All Respective Names are Trademarks of Nintendo 1996-2025.<br>
                        <strong class="text-white">This server is not affiliated with Nintendo, Creatures Inc. and GAME FREAK Inc.</strong>
                    </p>
                </div>
            </div>
        </div>
    </div>
</footer>

<div class="cookie-banner" id="cookieConsent">
    <p class="cookie-text">
        <i class="fas fa-cookie-bite text-warning me-2 fs-5"></i>
        Utilizamos cookies para melhorar sua experiência. Ao continuar, você concorda com nossa política.
    </p>
    <button type="button" class="btn btn-cookie" id="acceptCookies">ACEITAR</button>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const cookieConsent = document.getElementById('cookieConsent');
        const acceptCookies = document.getElementById('acceptCookies');
        const cookieName = 'cookieAccepted_v2'; // Mudei a versão para forçar reaparecer se necessário

        // 1. Verificar se o cookie já foi aceito
        if (localStorage.getItem(cookieName) === 'true') {
            cookieConsent.style.display = 'none';
        } else {
            // Pequeno delay para animação de entrada (se houver CSS animado) ou apenas UX
            setTimeout(() => {
                cookieConsent.style.display = 'flex'; 
            }, 1000);
        }

        // 2. Lidar com o clique no botão
        acceptCookies.addEventListener('click', function() {
            localStorage.setItem(cookieName, 'true');
            // Efeito de saída
            cookieConsent.style.opacity = '0';
            cookieConsent.style.transform = 'translate(-50%, 20px)';
            setTimeout(() => {
                cookieConsent.style.display = 'none';
            }, 300);
        });
    });
</script>

</body>
</html>