<?php
/**
 * Funções utilitárias para o site, incluindo Mercado Pago.
 */

// --- FUNÇÃO PARA BUSCAR CHAVES MP E CONFIGURAÇÃO DE BATOR ---
if (!function_exists('get_mp_config')) {
    function get_mp_config($pdo) {
        // Busca a configuração da tabela mp_config
        $stmt = $pdo->query("SELECT * FROM mp_config WHERE id = 1");
        $config = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$config) {
            // Retorna valores padrão (Fallback)
            return [
                'points_per_real' => 1.00, 
                'bonus_min_amount' => 35.00, 
                'bonus_percentage' => 10, 
                'public_key' => 'CHAVE_PUBLICA_NAO_CONFIGURADA', 
                'access_token' => 'CHAVE_PRIVADA_NAO_CONFIGURADA'
            ];
        }
        return $config;
    }
}


// --- FUNÇÃO PARA BUSCAR APENAS AS CHAVES DE ACESSO (Usada por process_payment e webhook) ---
// Nota: Esta função foi separada para clareza, mas é redundante se você usar get_mp_config.
// Vamos mantê-la simples usando get_mp_config:
if (!function_exists('get_mp_keys')) {
    function get_mp_keys($pdo) {
        $config = get_mp_config($pdo);
        return [
            'public_key' => $config['public_key'],
            'access_token' => $config['access_token']
        ];
    }
}


// --- FUNÇÃO DE GESTÃO DE OFERTAS (Exemplo de como ficaria em functions.php se necessário) ---
/*
if (!function_exists('get_mp_offers')) {
    function get_mp_offers($pdo) {
        return $pdo->query("SELECT * FROM mp_offers ORDER BY priority ASC, amount ASC")->fetchAll(PDO::FETCH_ASSOC);
    }
}
*/

// Adicione aqui qualquer outra função utilitária do seu site