<?php
// includes/gacha_engine.php

/**
 * Lógica principal de sorteio do Gacha
 * @param PDO $pdo Objeto PDO de conexão.
 * @return array|null Item sorteado ou null.
 */
function spinGacha($pdo) {
    $stmt = $pdo->query("SELECT id, item_name, item_id, count, image_url, probability, rarity, description FROM gacha_items");
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($items)) return null;

    // Gera número aleatório com precisão de 4 casas decimais (0.0001 a 100.0000)
    $rand = mt_rand(1, 1000000) / 10000; 
    $current_prob = 0;

    foreach ($items as $item) {
        $itemProb = (float)$item['probability']; 
        $current_prob += $itemProb;
        
        if ($rand <= $current_prob) {
            return $item;
        }
    }
    
    // Fallback: Retorna o último item (normalmente o mais comum)
    return $items[count($items) - 1]; 
}

/**
 * Retorna cores e classes CSS para uma raridade (CORRIGIDO COM SWITCH)
 * @param string $rarity
 * @return array [Cor Hexadecimal, Classe Bootstrap]
 */
function getRarityColor($rarity) {
    switch ($rarity) {
        case 'Comum':    return ['#94a3b8', 'bg-secondary']; 
        case 'Incomum':  return ['#22c55e', 'bg-success'];
        case 'Rara':     return ['#3b82f6', 'bg-primary']; 
        case 'Epica':    return ['#a855f7', 'bg-purple']; 
        case 'Lendaria': return ['#eab308', 'bg-warning text-dark'];
        case 'Mitica':   return ['#ef4444', 'bg-danger'];
        default:         return ['#ffffff', 'bg-info'];
    }
}
?>