<?php
// index.php
// Configurações de Erro (Desative em produção colocando 0)
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
require_once 'includes/conexao.php'; // Garanta que este caminho está correto

// --- 1. SEO & CONFIGURAÇÕES ---
try {
    $stmtConfig = $pdo->query("SELECT * FROM site_config LIMIT 1");
    $dbConfig = $stmtConfig->fetch(PDO::FETCH_ASSOC);
} catch (Exception $e) { $dbConfig = []; }

$serverName = $dbConfig['server_name'] ?? 'Pokemon Relics';
$page_title = "Início - " . $serverName;
$metaDesc = $dbConfig['meta_description'] ?? 'O melhor MMORPG de Pokémon. Batalhe, capture e explore!';

// --- 2. SISTEMA DE LIKES (AJAX) ---
$userIp = $_SERVER['REMOTE_ADDR'];
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'like_news') {
    header('Content-Type: application/json');
    if (!isset($_SESSION['account_id'])) {
        echo json_encode(['success' => false, 'message' => 'Faça login para curtir.']);
        exit;
    }
    $newsId = (int)$_POST['news_id'];
    
    $check = $pdo->prepare("SELECT id FROM site_news_likes WHERE news_id = ? AND ip = ?");
    $check->execute([$newsId, $userIp]);
    
    if ($check->rowCount() == 0) {
        $pdo->prepare("INSERT INTO site_news_likes (news_id, ip) VALUES (?, ?)")->execute([$newsId, $userIp]);
        $liked = true;
    } else {
        $pdo->prepare("DELETE FROM site_news_likes WHERE news_id = ? AND ip = ?")->execute([$newsId, $userIp]);
        $liked = false;
    }
    $count = $pdo->prepare("SELECT COUNT(*) FROM site_news_likes WHERE news_id = ?");
    $count->execute([$newsId]);
    echo json_encode(['success' => true, 'likes' => $count->fetchColumn(), 'user_liked' => $liked]);
    exit;
}

// --- 3. DADOS DO SERVIDOR ---
// Online Check
try {
    $onlineCount = $pdo->query("SELECT COUNT(*) FROM players WHERE online = 1")->fetchColumn();
} catch(Exception $e) { $onlineCount = 0; }

// Notícias
$newsPerPage = 5;
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($page - 1) * $newsPerPage;
$totalNews = $pdo->query("SELECT COUNT(*) FROM site_news")->fetchColumn();
$totalPages = ceil($totalNews / $newsPerPage);

$sqlNews = "SELECT n.*, 
            (SELECT COUNT(*) FROM site_news_likes WHERE news_id = n.id) as total_likes,
            (SELECT COUNT(*) FROM site_news_likes WHERE news_id = n.id AND ip = :userIp) as i_liked
            FROM site_news n ORDER BY id DESC LIMIT :limit OFFSET :offset";
            
$stmtNews = $pdo->prepare($sqlNews);
$stmtNews->bindParam(':userIp', $userIp, PDO::PARAM_STR);
$stmtNews->bindParam(':limit', $newsPerPage, PDO::PARAM_INT);
$stmtNews->bindParam(':offset', $offset, PDO::PARAM_INT);
$stmtNews->execute();
$newsList = $stmtNews->fetchAll();

// --- 4. CORREÇÃO DAS MORTES ---
try {
    $sqlDeaths = "SELECT 
                    p.name as victim,
                    pd.level, 
                    pd.date,
                    ek.name as monster_name, 
                    pl.name as player_killer_name,
                    pd.mostdamage_by, 
                    pd.monster
                  FROM player_deaths pd
                  JOIN players p ON p.id = pd.player_id
                  LEFT JOIN killers k ON k.death_id = pd.id AND k.final_hit = 1
                  LEFT JOIN environment_killers ek ON ek.kill_id = k.id
                  LEFT JOIN player_killers pk ON pk.kill_id = k.id
                  LEFT JOIN players pl ON pl.id = pk.player_id
                  ORDER BY pd.date DESC 
                  LIMIT 5";
                  
    $deathsData = $pdo->query($sqlDeaths)->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) { $deathsData = []; }

// Top Guildas
$topGuilds = $pdo->query("SELECT g.id, g.name, g.logo_gfx, (SELECT COUNT(*) FROM guild_membership WHERE guild_id = g.id) as total_members FROM guilds g ORDER BY total_members DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);

// Top Players
$topPlayersLevel = $pdo->query("SELECT name, level FROM players WHERE group_id < 2 ORDER BY level DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);

include 'includes/header.php'; 
?>

<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script src="https://cdn.jsdelivr.net/npm/typed.js@2.0.12"></script>

<style>
    /* --- CONFIGURAÇÃO VISUAL GERAL --- */
    :root {
        --bg-dark: #0f172a;
        --bg-card: #1e293b;
        --primary: #3b82f6;
        --primary-glow: rgba(59, 130, 246, 0.6);
        --accent: #fbbf24; /* Amarelo Pokémon */
        --text-main: #ffffff; /* Branco puro */
        --text-sub: #cbd5e1; /* Cinza claro prateado */
    }

    body {
        background-color: #0b1120;
        color: var(--text-main);
        overflow-x: hidden;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    
    /* Força textos brancos onde o bootstrap tenta colocar cinza */
    h1, h2, h3, h4, h5, h6 { color: #ffffff !important; }
    .text-muted { color: #94a3b8 !important; }

    /* --- 1. DEATH TICKER (Barra de Notícias) --- */
    .death-ticker {
        background: linear-gradient(90deg, #1e1b4b 0%, #0f172a 100%);
        border-bottom: 1px solid rgba(255,255,255,0.1);
        padding: 8px 0;
        font-size: 0.9rem;
        color: var(--text-sub);
        position: relative;
        z-index: 20;
    }
    .death-tag { font-weight: 800; color: #ef4444; margin-right: 5px; text-transform: uppercase; font-size: 0.8rem; }
    .death-victim { color: #fff; font-weight: 600; }
    .death-killer { color: var(--accent); font-weight: 600; }

    /* --- 2. HERO SECTION --- */
    .hero-section {
        position: relative;
        /* Altura mínima ajustada para mobile e desktop */
        min-height: 80vh; 
        display: flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
        padding-top: 80px; /* Espaço para o Header fixo não cobrir */
        padding-bottom: 50px;
    }

    /* Imagem de Fundo */
    .hero-bg {
        position: absolute; top: 0; left: 0; width: 100%; height: 100%;
        background: url('images/hero.png') center/cover no-repeat; 
        background-color: #0f172a; 
        z-index: 1;
        filter: brightness(0.4); /* Escurece a imagem para o texto brilhar */
        transform: scale(1.05);
        animation: breath 15s infinite alternate;
    }

    .hero-content {
        position: relative; z-index: 5;
        text-align: center; max-width: 900px; padding: 20px;
    }

    .server-logo-text {
        font-family: 'Rajdhani', sans-serif; /* Se não tiver a fonte, use Impact ou Arial Black */
        font-size: 5rem;
        font-weight: 900;
        line-height: 1.1;
        text-transform: uppercase;
        /* Efeito Metálico/Glow */
        background: -webkit-linear-gradient(#fff, #93c5fd);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        text-shadow: 0 0 30px rgba(59, 130, 246, 0.6);
        margin-bottom: 15px;
    }

    .hero-typed {
        font-size: 1.5rem; color: var(--accent); font-weight: 600;
        min-height: 35px; margin-bottom: 40px; letter-spacing: 1px;
        text-shadow: 0 2px 4px rgba(0,0,0,0.8);
    }

    .cta-group .btn {
        padding: 15px 40px; font-size: 1.1rem; letter-spacing: 1px;
        border-radius: 50px; text-transform: uppercase; margin: 10px;
        transition: all 0.3s;
        font-weight: 700;
    }
    .btn-hero-primary {
        background: var(--primary); color: white; border: none;
        box-shadow: 0 0 20px var(--primary-glow);
    }
    .btn-hero-primary:hover {
        background: #2563eb; transform: translateY(-5px);
        box-shadow: 0 0 40px var(--primary-glow); color: white;
    }

    @keyframes breath { from { transform: scale(1.0); } to { transform: scale(1.1); } }

    /* --- 3. STATS STRIP (Barra de Status) --- */
    .stats-container {
        position: relative;
        z-index: 10;
        padding: 0 15px;
    }
    
    .stats-strip {
        background: rgba(30, 41, 59, 0.9); /* Mais opaco para leitura */
        backdrop-filter: blur(12px);
        border: 1px solid rgba(255,255,255,0.1);
        padding: 25px 0;
        box-shadow: 0 10px 40px rgba(0,0,0,0.5);
        border-radius: 12px;
    }

    /* Comportamento Desktop (Flutuante) */
    @media (min-width: 992px) {
        .stats-container { margin-top: -80px; margin-bottom: 60px; }
        .stat-item { border-right: 1px solid rgba(255,255,255,0.1); }
    }
    
    /* Comportamento Mobile (Empilhado) */
    @media (max-width: 991px) {
        .stats-container { margin-top: 20px; margin-bottom: 40px; }
        .stat-item { border-bottom: 1px solid rgba(255,255,255,0.1); padding: 15px 0; }
        .stat-item:last-child { border-bottom: none; }
    }

    .stat-item:last-child { border-right: none; }
    .stat-number { font-size: 2.2rem; font-weight: 800; color: white; line-height: 1; text-shadow: 0 0 10px rgba(255,255,255,0.3); }
    .stat-label { font-size: 0.85rem; text-transform: uppercase; color: var(--text-sub); letter-spacing: 1px; margin-top: 5px; font-weight: 600; }

    /* --- 4. LAYOUT PRINCIPAL --- */
    .main-grid {
        display: grid; grid-template-columns: 2.5fr 1fr; gap: 40px;
        margin-bottom: 60px;
    }

    /* Cards de Notícia */
    .news-card {
        background: var(--bg-card);
        border: 1px solid rgba(255,255,255,0.05);
        border-radius: 16px;
        overflow: hidden;
        margin-bottom: 40px;
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.3);
        transition: transform 0.3s, border-color 0.3s;
    }
    .news-card:hover { transform: translateY(-5px); border-color: var(--primary); }
    
    .news-header { position: relative; height: 300px; }
    .news-header img { width: 100%; height: 100%; object-fit: cover; }
    .news-header::after {
        content: ''; position: absolute; bottom: 0; left: 0; width: 100%; height: 100%;
        background: linear-gradient(to top, var(--bg-card) 5%, transparent 100%);
    }
    
    .news-body { padding: 30px; position: relative; z-index: 2; margin-top: -60px; }
    .news-date {
        background: var(--primary); color: white; display: inline-block;
        padding: 5px 12px; border-radius: 6px; font-weight: 700; font-size: 0.8rem;
        margin-bottom: 15px; box-shadow: 0 4px 10px rgba(0,0,0,0.3);
    }
    .news-title { font-size: 1.8rem; font-weight: 800; color: white; margin-bottom: 20px; text-shadow: 0 2px 4px rgba(0,0,0,0.5); }
    .news-content { color: var(--text-sub); font-size: 1.05rem; line-height: 1.7; }
    .news-content img { max-width: 100%; height: auto; border-radius: 8px; margin: 15px 0; border: 1px solid rgba(255,255,255,0.1); }
    
    .news-actions {
        padding: 15px 30px; border-top: 1px solid rgba(255,255,255,0.05);
        display: flex; justify-content: space-between; align-items: center;
        background: rgba(0,0,0,0.2);
    }

    /* Widgets Lateral */
    .sidebar-widget {
        background: var(--bg-card);
        border: 1px solid rgba(255,255,255,0.05);
        border-radius: 16px;
        padding: 25px;
        margin-bottom: 30px;
    }
    .widget-title {
        font-size: 1.2rem; font-weight: 700; color: white;
        border-left: 4px solid var(--accent); padding-left: 15px;
        margin-bottom: 20px; text-transform: uppercase;
    }
    
    .rank-row {
        display: flex; align-items: center; padding: 10px 0;
        border-bottom: 1px solid rgba(255,255,255,0.05);
    }
    .rank-row:last-child { border-bottom: none; }
    .rank-pos {
        width: 26px; height: 26px; background: #334155; color: #fff;
        border-radius: 4px; display: flex; align-items: center; justify-content: center;
        font-weight: bold; font-size: 0.8rem; margin-right: 12px;
    }
    .rank-pos.first { background: var(--accent); color: #000; box-shadow: 0 0 10px rgba(251, 191, 36, 0.4); }
    .rank-info a { color: #e2e8f0; text-decoration: none; font-weight: 600; font-size: 0.95rem; transition: color 0.2s;}
    .rank-info a:hover { color: var(--primary); }
    .rank-stat { margin-left: auto; color: var(--primary); font-weight: 700; font-family: monospace; font-size: 1.1rem; }

    /* Features Section */
    .features-section { padding: 80px 0; background: #0f172a; border-top: 1px solid rgba(255,255,255,0.05); }
    .feature-box {
        text-align: center; padding: 35px 25px;
        background: linear-gradient(145deg, #1e293b, #0f172a);
        border-radius: 16px; border: 1px solid rgba(255,255,255,0.05);
        height: 100%; transition: transform 0.3s;
    }
    .feature-box:hover { transform: translateY(-10px); border-color: var(--primary); }
    .feature-icon {
        font-size: 3rem; color: var(--primary); margin-bottom: 20px;
        text-shadow: 0 0 20px var(--primary-glow);
    }

    /* --- RESPONSIVIDADE (Mobile Fixes) --- */
    @media (max-width: 991px) {
        .main-grid { grid-template-columns: 1fr; gap: 30px; }
        
        .server-logo-text { font-size: 3.5rem; }
        .hero-typed { font-size: 1.1rem; }
        .hero-section { min-height: auto; padding: 120px 0 60px 0; } /* Mais espaço pro header */

        .news-header { height: 200px; }
        .news-body { padding: 20px; margin-top: -40px; }
        .news-title { font-size: 1.4rem; }
        
        .container, .container-fluid { padding-left: 20px; padding-right: 20px; }
    }
    
    @media (max-width: 576px) {
        .server-logo-text { font-size: 2.8rem; }
        .cta-group .btn { display: block; width: 100%; margin: 10px 0; }
        .stat-number { font-size: 1.8rem; }
    }
</style>

<div class="death-ticker">
    <div class="container-fluid">
        <marquee onmouseover="this.stop();" onmouseout="this.start();" scrollamount="5">
            <?php 
            if(empty($deathsData)) {
                echo '<span class="death-item me-5 text-muted">Nenhuma morte registrada recentemente. O mundo está em paz... por enquanto.</span>';
            } else {
                foreach($deathsData as $d): 
                    // Lógica para nome do Killer
                    $killerName = 'Desconhecido';
                    if (!empty($d['monster_name'])) { $killerName = $d['monster_name']; } 
                    elseif (!empty($d['player_killer_name'])) { $killerName = $d['player_killer_name']; }
                    elseif (!empty($d['mostdamage_by']) && strtolower($d['mostdamage_by']) !== 'none' && strtolower($d['mostdamage_by']) !== $d['victim']) { $killerName = $d['mostdamage_by']; }
                    elseif (!empty($d['monster'])) { $killerName = $d['monster']; }
                    
                    $killerDisplay = htmlspecialchars($killerName);
                    $victimDisplay = htmlspecialchars($d['victim']);
            ?>
                <span class="death-item me-5">
                    <span class="death-tag">Morte:</span>
                    <span class="death-victim"><?php echo $victimDisplay; ?></span> (Lvl <?php echo $d['level']; ?>)
                    caiu perante <span class="death-killer"><?php echo $killerDisplay; ?></span>
                    <small class="text-muted ms-1">[<?php echo date('H:i', $d['date']); ?>]</small>
                </span>
            <?php endforeach; } ?>
        </marquee>
    </div>
</div>

<div class="hero-section">
    <div class="hero-bg"></div>
    <div class="hero-content">
        <h1 class="server-logo-text" data-aos="zoom-in" data-aos-duration="1500"><?php echo strtoupper($serverName); ?></h1>
        <div class="hero-typed"><span id="typed-text"></span></div>
        
        <div class="cta-group" data-aos="fade-up" data-aos-delay="500">
            <a href="downloads.php" class="btn btn-hero-primary fw-bold">
                <i class="fas fa-download me-2"></i> BAIXAR CLIENTE
            </a>
            <a href="register.php" class="btn btn-outline-light fw-bold border-2">
                CRIAR CONTA
            </a>
        </div>
    </div>
</div>

<div class="container stats-container">
    <div class="stats-strip">
        <div class="row g-0">
            <div class="col-6 col-md-3 stat-item text-center">
                <div class="stat-number text-success"><?php echo $onlineCount; ?></div>
                <div class="stat-label">Jogadores Online</div>
            </div>
            <div class="col-6 col-md-3 stat-item text-center">
                <div class="stat-number text-warning">24h</div>
                <div class="stat-label">Servidor Estável</div>
            </div>
            <div class="col-6 col-md-3 stat-item text-center">
                <div class="stat-number text-primary">150+</div>
                <div class="stat-label">Novos Pokémons</div>
            </div>
            <div class="col-6 col-md-3 stat-item text-center">
                <div class="stat-number text-info" id="clock">00:00</div>
                <div class="stat-label">Horário Server</div>
            </div>
        </div>
    </div>
</div>

<div class="container main-grid">
    
    <div class="content-col">
        <h3 class="mb-4 text-white fw-bold border-start border-4 border-primary ps-3" data-aos="fade-right">
            Últimas do Mundo Pokémon
        </h3>

        <?php if(empty($newsList)): ?>
            <div class="alert alert-dark text-center py-5 border-0 shadow">
                <i class="fas fa-ghost fa-3x text-muted mb-3"></i>
                <p class="text-white">Nenhuma notícia encontrada.</p>
            </div>
        <?php endif; ?>

        <?php foreach($newsList as $news): 
            $img = !empty($news['image']) ? $news['image'] : 'images/default_news.jpg';
            if((!file_exists($img) && strpos($img, 'http') === false) || empty($news['image'])) {
                 $img = 'https://wallpapers.com/images/hd/pokemon-landscape-2400-x-1350-background-20m294k1f4b5j3k4.jpg';
            }
        ?>
        <article class="news-card" data-aos="fade-up">
            <div class="news-header">
                <img src="<?php echo $img; ?>" alt="Capa">
            </div>
            <div class="news-body">
                <div class="news-date">
                    <i class="far fa-clock me-1"></i> <?php echo date('d M Y', $news['date']); ?>
                </div>
                <h2 class="news-title"><?php echo htmlspecialchars($news['title']); ?></h2>
                
                <div class="news-content">
                    <?php echo html_entity_decode($news['body']); ?>
                </div>
            </div>
            <div class="news-actions">
                <div class="d-flex align-items-center gap-2">
                    <div class="bg-primary rounded-circle text-white d-flex align-items-center justify-content-center" style="width:30px; height:30px">
                        <i class="fas fa-crown small"></i>
                    </div>
                    <span class="text-white fw-bold small">Staff Team</span>
                </div>
                
                <button class="btn text-white fw-bold" onclick="likeNews(this, <?php echo $news['id']; ?>)" <?php echo !isset($_SESSION['account_id']) ? 'disabled title="Login necessário"' : ''; ?>>
                    <i class="<?php echo ($news['i_liked'] > 0) ? 'fas text-danger' : 'far'; ?> fa-heart me-1"></i>
                    <span class="like-counter"><?php echo $news['total_likes']; ?></span>
                </button>
            </div>
        </article>
        <?php endforeach; ?>

        <?php if ($totalPages > 1): ?>
            <div class="d-flex justify-content-center mt-5">
                <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                    <a href="?page=<?php echo $i; ?>" class="btn btn-outline-light mx-1 <?php echo ($i == $page) ? 'active bg-primary border-primary' : ''; ?>">
                        <?php echo $i; ?>
                    </a>
                <?php endfor; ?>
            </div>
        <?php endif; ?>
    </div>

    <div class="sidebar-col">
        
        <div class="sidebar-widget" data-aos="fade-left">
            <h5 class="widget-title">Buscar Treinador</h5>
            <form action="character.php" method="GET" class="position-relative">
                <input type="text" name="name" class="form-control bg-dark text-white border-secondary" placeholder="Nome do personagem..." style="padding-right: 40px; color: white;">
                <button type="submit" class="btn position-absolute top-0 end-0 text-white"><i class="fas fa-search"></i></button>
            </form>
        </div>

        <div class="sidebar-widget" data-aos="fade-left" data-aos-delay="100">
            <h5 class="widget-title">Top Level</h5>
            <?php $i=1; foreach($topPlayersLevel as $player): ?>
            <div class="rank-row">
                <div class="rank-pos <?php echo ($i==1)?'first':''; ?>"><?php echo $i++; ?></div>
                <div class="rank-info">
                    <a href="character.php?name=<?php echo urlencode($player['name']); ?>"><?php echo htmlspecialchars($player['name']); ?></a>
                </div>
                <div class="rank-stat"><?php echo $player['level']; ?></div>
            </div>
            <?php endforeach; ?>
        </div>

        <div class="sidebar-widget" data-aos="fade-left" data-aos-delay="200">
            <h5 class="widget-title">Guildas Poderosas</h5>
            <?php if(empty($topGuilds)): ?>
                <p class="text-muted small">Nenhuma guilda dominante ainda.</p>
            <?php else: $i=1; foreach($topGuilds as $guild): ?>
            <div class="rank-row">
                <div class="rank-pos"><?php echo $i++; ?></div>
                <div class="rank-info d-flex align-items-center">
                     <img src="images/guilds/<?php echo !empty($guild['logo_gfx']) ? $guild['logo_gfx'] : 'default.png'; ?>" 
                          style="width:24px; height:24px; margin-right:8px; border-radius:4px;" 
                          onerror="this.src='images/default_guild.png'">
                    <a href="guilds.php?view=<?php echo $guild['id']; ?>"><?php echo htmlspecialchars($guild['name']); ?></a>
                </div>
                <div class="rank-stat text-muted small"><?php echo $guild['total_members']; ?></div>
            </div>
            <?php endforeach; endif; ?>
        </div>

        <div class="sidebar-widget text-center bg-primary border-0" data-aos="zoom-in" style="background: linear-gradient(45deg, #3b82f6, #2563eb);">
            <i class="fab fa-discord fa-3x text-white mb-3"></i>
            <h5 class="fw-bold text-white">Comunidade Discord</h5>
            <p class="text-white-50 small mb-3">Participe de sorteios, eventos e converse com a staff.</p>
            <a href="#" class="btn btn-light w-100 fw-bold text-primary rounded-pill">ENTRAR AGORA</a>
        </div>

    </div>
</div>

<div class="features-section">
    <div class="container">
        <div class="text-center mb-5" data-aos="fade-up">
            <h2 class="fw-bold text-white font-monospace">POR QUE JOGAR?</h2>
            <div class="bg-primary mx-auto" style="width: 60px; height: 3px;"></div>
        </div>
        
        <div class="row g-4">
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
                <div class="feature-box">
                    <i class="fas fa-gamepad feature-icon"></i>
                    <h4 class="text-white fw-bold">Jogabilidade Única</h4>
                    <p class="text-muted">Sistema de batalha balanceado, cooldown bar exclusivo e mecânicas modernas.</p>
                </div>
            </div>
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
                <div class="feature-box">
                    <i class="fas fa-globe-americas feature-icon"></i>
                    <h4 class="text-white fw-bold">Mapa Gigante</h4>
                    <p class="text-muted">Explore Kanto, Johto e ilhas exclusivas repletas de mistérios e quests lendárias.</p>
                </div>
            </div>
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="300">
                <div class="feature-box">
                    <i class="fas fa-shield-alt feature-icon"></i>
                    <h4 class="text-white fw-bold">Segurança & Estabilidade</h4>
                    <p class="text-muted">Servidor dedicado 24/7 sem lag, com proteção DDoS e cliente anti-hack.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>

<script>
    // Inicializa Animações
    AOS.init({ once: true });

    // Efeito de Digitação no Hero
    var typed = new Typed('#typed-text', {
        strings: ['Capture todos eles.', 'Torne-se uma Lenda.', 'Explore o Mundo.', 'Batalhe PVP.'],
        typeSpeed: 50,
        backSpeed: 30,
        loop: true,
        backDelay: 2000
    });

    // Relógio
    setInterval(() => {
        const now = new Date();
        document.getElementById('clock').innerText = now.toLocaleTimeString('pt-BR', {hour: '2-digit', minute:'2-digit'});
    }, 1000);

    // Sistema de Like (AJAX)
    function likeNews(btn, id) {
        if(btn.disabled) return;
        const counter = btn.querySelector('.like-counter');
        const icon = btn.querySelector('i');
        
        const formData = new FormData();
        formData.append('action', 'like_news');
        formData.append('news_id', id);

        fetch('index.php', { method:'POST', body:formData })
        .then(res => res.json())
        .then(data => {
            if(data.success){
                counter.innerText = data.likes;
                if(data.user_liked){
                    icon.classList.remove('far');
                    icon.classList.add('fas', 'text-danger');
                } else {
                    icon.classList.add('far');
                    icon.classList.remove('fas', 'text-danger');
                }
            } else {
                alert(data.message);
            }
        })
        .catch(error => console.error('Erro:', error));
    }
</script>