import type { TinyMCE } from 'tinymce/core/api/PublicApi';

declare let tinymce: TinyMCE;

export default (): void => {

  tinymce.init({
    selector: 'textarea.tiny-text',
    license_key: 'gpl',
    theme: 'silver',
    toolbar: 'styles',
    plugins: [ 'lists', 'autolink', 'autosave', 'insertdatetime' ],
    style_formats: [
      { title: 'Bold text', inline: 'b' },
      { title: 'Red text', inline: 'span', styles: { color: '#ff0000' }},
      { title: 'Red header', block: 'h1', styles: { color: '#ff0000' }},
      { title: 'Example 1', inline: 'span', classes: 'example1' },
      { title: 'Example 2', inline: 'span', classes: 'example2' },
      { title: 'Table styles' },
      { title: 'Table row 1', selector: 'tr', classes: 'tablerow1' },
      {
        title: 'Headings', items: [
          { title: 'Heading 1', format: 'h1' },
          { title: 'Heading 2', format: 'h2' },
          { title: 'Heading 3', format: 'h3' },
          { title: 'Heading 4', format: 'h4' },
          { title: 'Heading 5', format: 'h5' },
          { title: 'Heading 6', format: 'h6' }
        ]
      },

      {
        title: 'Inline', items: [
          { title: 'Bold', icon: 'bold', format: 'bold' },
          { title: 'Italic', icon: 'italic', format: 'italic' },
          { title: 'Underline', icon: 'underline', format: 'underline' },
          { title: 'Strikethrough', icon: 'strikethrough', format: 'strikethrough' },
          { title: 'Superscript', icon: 'superscript', format: 'superscript' },
          { title: 'Subscript', icon: 'subscript', format: 'subscript' },
          { title: 'Code', icon: 'code', format: 'code' }
        ]
      },

      {
        title: 'Blocks', items: [
          { title: 'Paragraph', format: 'p' },
          { title: 'Blockquote', format: 'blockquote' },
          { title: 'Div', format: 'div' },
          { title: 'Pre', format: 'pre' }
        ]
      },

      {
        title: 'Alignment', items: [
          { title: 'Left', icon: 'alignleft', format: 'alignleft' },
          { title: 'Center', icon: 'aligncenter', format: 'aligncenter' },
          { title: 'Right', icon: 'alignright', format: 'alignright' },
          { title: 'Justify', icon: 'alignjustify', format: 'alignjustify' }
        ]
      }
    ]
  });

  tinymce.init({
    selector: 'textarea.tiny-text2',
    license_key: 'gpl',
    theme: 'silver',
    toolbar: 'styles',
    block_formats: 'Paragraph=p;Heading 1=h1;Heading 2=h2;Separator Name=|;Heading 3=h3',
    plugins: [ 'lists', 'autolink', 'autosave', 'insertdatetime' ]
  });
};
