<?php 
// modals/sell_character_modal.php
// Requer que $char, $minPrice e $minLevel estejam definidos.
?>

<div class="modal fade" id="sellModal<?php echo $char['id']; ?>" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content text-white" style="background: #1e293b; border: 1px solid rgba(255,255,255,0.1);">
            <div class="modal-header border-secondary">
                <h5 class="modal-title fw-bold">Vender Personagem: <?php echo htmlspecialchars($char['name']); ?></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="sell_character.php" method="POST">
                    <input type="hidden" name="player_id" value="<?php echo $char['id']; ?>">
                    <input type="hidden" name="action" value="list_for_sale">

                    <div class="alert alert-warning small">
                        A comissão do site é de **<?php echo $config['admin_commission_percent']; ?>%** do valor final. O valor mínimo é **<?php echo $minPrice; ?> PPS**.
                    </div>

                    <div class="mb-3">
                        <label class="form-label text-soft small">Preço Desejado (Pontos Premium - PPS)</label>
                        <input type="number" name="price" class="form-control bg-dark text-white border-secondary" required min="<?php echo $minPrice; ?>" placeholder="<?php echo $minPrice; ?> PPS">
                    </div>
                    
                    <div class="mb-3">
                        <p class="text-white fw-bold mb-1">Itens Adicionais</p>
                        <p class="text-soft small">
                            Serão verificados itens especiais (montarias, addons, etc.) e itens marcados com a **Storage Key <?php echo $config['char_item_storage_key']; ?>** no seu Depot Locker. O restante será perdido!
                        </p>
                    </div>

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" value="1" id="confirmSell<?php echo $char['id']; ?>" required>
                        <label class="form-check-label text-white small" for="confirmSell<?php echo $char['id']; ?>">
                            Confirmo que entendi as regras e que o personagem deve estar **offline** para a venda.
                        </label>
                    </div>

                    <button type="submit" class="btn btn-success w-100 fw-bold shadow-lg">COLOCAR <?php echo strtoupper($char['name']); ?> À VENDA</button>
                </form>
            </div>
        </div>
    </div>
</div>