<?php
// Simulação das variáveis de configuração (Definir estas variáveis é crucial para o header e footer)
$siteConfig = [
    'server_name' => 'PokeServer',
    'color_header' => '#dc2626', // Vermelho Principal (Pokémon)
    'color_footer' => '#f8f9fa'  // Fundo Claro
];

// Requer o header, que deve conter <html>, <head>, <body> e o cabeçalho de navegação
require_once('includes/header.php'); 
?>

<div class="container my-5">
    <h1 class="text-center mb-4 text-primary">Política de Privacidade</h1>
    <p class="text-muted text-center mb-5 fst-italic">Última atualização: Dezembro de 2025</p>

    <section class="mb-5">
        <h2 class="h4 mb-3 fw-bold">1. Introdução</h2>
        <p>A privacidade dos nossos jogadores é de extrema importância para o <strong>PokeServer</strong>. Esta Política descreve como coletamos, usamos, armazenamos e protegemos as informações pessoais que você nos fornece ao utilizar nosso jogo e website. Ao se registrar, você concorda com os termos desta política.</p>
    </section>
    
    <hr>

    <section class="mb-5">
        <h2 class="h4 mb-3 fw-bold">2. Informações que Coletamos</h2>
        <p>Coletamos informações essenciais para operar e melhorar o serviço que oferecemos, garantindo a segurança e a conformidade legal. Estas incluem:</p>
        <ul>
            <li><strong>Informações de Cadastro:</strong> Nome de usuário, endereço de e-mail e senha criptografada (hash).</li>
            <li><strong>Dados de Jogo:</strong> Endereço IP (para segurança, detecção de fraude e geolocalização básica), logs de atividades no jogo (compras, trocas, batalhas, logs de chat), e informações do seu personagem (progresso e inventário).</li>
            <li><strong>Comunicação:</strong> Registros de conversas em canais de suporte (*tickets*) ou comunicações diretas com a Staff.</li>
            <li><strong>Informações de Doação:</strong> Histórico de doações e comprovantes de pagamento, mas **nunca** dados de cartão de crédito ou bancários (processados por terceiros).</li>
        </ul>
    </section>

    <hr>

    <section class="mb-5">
        <h2 class="h4 mb-3 fw-bold">3. Uso das Informações</h2>
        <p>Utilizamos suas informações de forma responsável e para os seguintes propósitos:</p>
        <ul>
            <li>Permitir o acesso, autenticar sua conta e garantir a jogabilidade no servidor.</li>
            <li>Monitorar a atividade do servidor para garantir a segurança da conta (prevenção de *hacks* e fraudes) e aplicar as <a href="regras.php">Regras do Jogo</a>.</li>
            <li>Analisar dados de uso para melhorar a experiência de jogo, identificar bugs e otimizar o desempenho do servidor.</li>
            <li>Comunicar-se com você sobre atualizações, promoções, manutenção ou questões de conta.</li>
        </ul>
    </section>

    <hr>

    <section class="mb-5">
        <h2 class="h4 mb-3 fw-bold">4. Cookies e Tecnologias Semelhantes</h2>
        <p>Utilizamos cookies para o funcionamento básico do site (manter você logado e lembrar suas preferências). Podemos usar serviços de análise de terceiros (como Google Analytics) que também utilizam cookies para entender o tráfego do site. Você tem o direito de gerenciar ou desativar os cookies através das configurações do seu navegador.</p>
    </section>

    <hr>

    <section class="mb-5">
        <h2 class="h4 mb-3 fw-bold">5. Segurança dos Dados</h2>
        <p>Implementamos medidas de segurança técnicas, físicas e administrativas para proteger suas informações contra acesso não autorizado, alteração, divulgação ou destruição. No entanto, é importante lembrar que **nenhum método de transmissão pela internet é 100% seguro**, e você também deve proteger sua senha e informações de conta.</p>
    </section>

    <hr>

    <section class="mb-5">
        <h2 class="h4 mb-3 fw-bold">6. Seus Direitos</h2>
        <p>De acordo com a legislação de proteção de dados (como a LGPD, se aplicável), você tem direitos sobre seus dados:</p>
        <ul>
            <li>**Acesso:** Solicitar uma cópia dos dados pessoais que mantemos sobre você.</li>
            <li>**Correção:** Solicitar a correção de dados incompletos ou incorretos.</li>
            <li>**Exclusão:** Solicitar a exclusão de seus dados, sujeito às obrigações legais de retenção.</li>
        </ul>
        <p class="mt-3">Para exercer estes direitos, por favor, entre em contato conosco através do canal de Contato.</p>
    </section>

    <div class="alert alert-info text-center">
        <p class="mb-0 fw-bold">Para qualquer dúvida sobre esta Política, entre em contato conosco em <a href="contato.php">nossa página de Contato</a>.</p>
    </div>
</div>

<?php 
// Requer o footer, que deve incluir o rodapé, o aviso de cookies e fechar as tags
require_once('includes/footer.php'); 
?>