<?php
$page_title = "Recuperar Acesso";
require 'includes/conexao.php';
include 'includes/header.php';

$msg = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $account = trim($_POST['account']);
    $rk = trim($_POST['recovery_key']);
    $new_pass = trim($_POST['new_password']);
    $confirm_pass = trim($_POST['confirm_password']);

    // 1. Validações Básicas
    if (empty($account) || empty($rk) || empty($new_pass)) {
        $msg = '<div class="alert alert-warning"><i class="fas fa-exclamation-circle"></i> Preencha todos os campos.</div>';
    } elseif ($new_pass !== $confirm_pass) {
        $msg = '<div class="alert alert-danger"><i class="fas fa-times"></i> As senhas novas não coincidem.</div>';
    } elseif (strlen($new_pass) < 6) {
        $msg = '<div class="alert alert-warning">A senha deve ter no mínimo 6 caracteres.</div>';
    } else {
        // 2. Tenta encontrar a conta com essa RK
        try {
            // Formata a RK para garantir (alguns usuários digitam com espaços extras)
            // Mas aqui vamos confiar que ele copiou e colou exatamente como gerou
            
            $stmt = $pdo->prepare("SELECT id FROM accounts WHERE name = ? AND recovery_key = ?");
            $stmt->execute([$account, $rk]);
            $accData = $stmt->fetch();

            if ($accData) {
                // 3. SUCESSO! TROCAR SENHA
                // Poketibia padrão usa SHA1. Se seu server for OTX novo, use sha256 ou o padrão dele.
                $newHash = sha1($new_pass);
                
                $upd = $pdo->prepare("UPDATE accounts SET password = ? WHERE id = ?");
                $upd->execute([$newHash, $accData['id']]);

                $msg = '<div class="alert alert-success shadow-sm border-0">
                            <h4 class="alert-heading fw-bold"><i class="fas fa-check-double"></i> Senha Alterada!</h4>
                            <p>O acesso à conta <strong>'.htmlspecialchars($account).'</strong> foi recuperado com sucesso.</p>
                            <hr>
                            <a href="login.php" class="btn btn-success fw-bold w-100">FAZER LOGIN AGORA</a>
                        </div>';
                
                // Limpa variáveis para não re-enviar
                $account = ''; $rk = '';
            } else {
                $msg = '<div class="alert alert-danger shadow-sm"><i class="fas fa-user-slash"></i> Dados inválidos! Verifique o nome da conta e a Recovery Key.</div>';
            }

        } catch (Exception $e) {
            $msg = '<div class="alert alert-danger">Erro no sistema. Contate o ADM.</div>';
        }
    }
}
?>

<style>
    .recovery-card {
        max-width: 500px;
        margin: 0 auto;
        border: none;
        border-radius: 15px;
        overflow: hidden;
    }
    .recovery-header {
        background: linear-gradient(135deg, #dc3545 0%, #ff6b6b 100%);
        color: white;
        padding: 30px;
        text-align: center;
    }
    .form-floating > .form-control:focus ~ label { color: #dc3545; }
    .form-control:focus { border-color: #dc3545; box-shadow: 0 0 0 0.25rem rgba(220, 53, 69, 0.25); }
</style>

<div class="container my-5">
    
    <div class="row justify-content-center">
        <div class="col-lg-6">
            
            <?php if (!empty($msg) && strpos($msg, 'alert-success') !== false): ?>
                <?php echo $msg; ?>
            <?php else: ?>

            <div class="card recovery-card shadow-lg">
                <div class="recovery-header">
                    <i class="fas fa-key fa-3x mb-3"></i>
                    <h2 class="fw-bold mb-0">Recuperação de Conta</h2>
                    <p class="mb-0 opacity-75">Use sua Recovery Key (RK) para redefinir a senha.</p>
                </div>
                
                <div class="card-body p-4">
                    <?php echo $msg; ?>

                    <form method="POST" autocomplete="off">
                        
                        <div class="mb-4">
                            <label class="form-label fw-bold text-muted small text-uppercase">Identificação</label>
                            <div class="form-floating mb-2">
                                <input type="text" class="form-control" id="accInput" name="account" placeholder="Nome da Conta" required value="<?php echo isset($account) ? $account : ''; ?>">
                                <label for="accInput"><i class="fas fa-user me-2"></i>Account Name</label>
                            </div>
                            <div class="form-floating">
                                <input type="text" class="form-control font-monospace" id="rkInput" name="recovery_key" placeholder="XXXX-XXXX-XXXX-XXXX" required style="text-transform: uppercase;">
                                <label for="rkInput"><i class="fas fa-lock me-2"></i>Recovery Key</label>
                            </div>
                            <div class="form-text small"><i class="fas fa-info-circle"></i> A chave gerada no seu painel (formato XXXX-XXXX...).</div>
                        </div>

                        <div class="mb-4">
                            <label class="form-label fw-bold text-muted small text-uppercase">Nova Segurança</label>
                            <div class="form-floating mb-2">
                                <input type="password" class="form-control" id="passInput" name="new_password" placeholder="Nova Senha" required>
                                <label for="passInput">Nova Senha</label>
                            </div>
                            <div class="form-floating">
                                <input type="password" class="form-control" id="confInput" name="confirm_password" placeholder="Confirmar Senha" required>
                                <label for="confInput">Confirmar Nova Senha</label>
                            </div>
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-danger btn-lg fw-bold">
                                <i class="fas fa-sync-alt me-2"></i> REDEFINIR SENHA
                            </button>
                            <a href="login.php" class="btn btn-light text-muted">Cancelar e Voltar</a>
                        </div>

                    </form>
                </div>
                <div class="card-footer bg-light text-center py-3">
                    <small class="text-muted">Não tem a RK? Infelizmente não é possível recuperar a conta sem ela.</small>
                </div>
            </div>

            <?php endif; ?>
        </div>
    </div>

</div>

<?php include 'includes/footer.php'; ?>