<?php
session_start();
// Se seu header já inclui a conexão, pode remover esta linha, mas deixei por segurança.
require_once 'includes/conexao.php';

// --- CONFIGURAÇÃO DE SEO ---
$serverName = "Pokemon Relics";
$page_title = "Regras Oficiais - $serverName";
$metaDesc   = "Leia as regras de conduta, PvP e termos de uso do $serverName. Evite punições e ajude a manter a comunidade saudável.";

// Inclui o cabeçalho
include 'includes/header.php'; 
?>

<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

<meta name="description" content="<?php echo $metaDesc; ?>">
<meta property="og:title" content="<?php echo $page_title; ?>">
<meta property="og:description" content="<?php echo $metaDesc; ?>">
<meta name="robots" content="index, follow">

<style>
    /* --- DESIGN SYSTEM (Deep Blue & Warning Red) --- */
    :root {
        --bg-dark: #0b1120;
        --bg-card: #162032;
        --text-bright: #ffffff;
        --text-soft: #cbd5e1; /* Branco Suave */
        --primary: #3b82f6;
        --danger: #ef4444;    /* Vermelho para Regras */
        --warning: #f59e0b;   /* Amarelo para Atenção */
        --border-light: rgba(255, 255, 255, 0.1);
    }

    body {
        background-color: var(--bg-dark);
        color: var(--text-bright);
        font-family: 'Segoe UI', sans-serif;
        overflow-x: hidden;
    }

    /* HERO SECTION */
    .rules-hero {
        background: linear-gradient(180deg, rgba(15, 23, 42, 0.9) 0%, #0b1120 100%), url('images/hero-rules.jpg') center/cover;
        /* Fallback se não tiver imagem: */
        background-color: #0f172a; 
        padding: 80px 0 50px 0;
        text-align: center;
        border-bottom: 1px solid var(--border-light);
        margin-top: -20px;
    }
    .hero-title {
        font-family: 'Rajdhani', sans-serif;
        font-size: 3.5rem;
        font-weight: 800;
        text-transform: uppercase;
        color: white;
        text-shadow: 0 0 25px rgba(239, 68, 68, 0.6); /* Glow Vermelho */
    }
    .hero-subtitle {
        font-size: 1.2rem;
        color: var(--text-soft);
        max-width: 700px;
        margin: 0 auto;
    }

    /* CARDS DE REGRAS */
    .rule-card {
        background: var(--bg-card);
        border: 1px solid var(--border-light);
        border-top: 4px solid var(--danger); /* Topo vermelho */
        border-radius: 12px;
        height: 100%;
        transition: transform 0.3s, box-shadow 0.3s;
    }
    .rule-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.3);
        border-top-color: #ff5252;
    }
    
    .card-header-custom {
        padding: 20px;
        border-bottom: 1px solid var(--border-light);
        display: flex;
        align-items: center;
        background: rgba(239, 68, 68, 0.1); /* Fundo vermelho bem suave */
    }
    
    .icon-box {
        width: 50px; height: 50px;
        background: var(--danger);
        color: white;
        border-radius: 10px;
        display: flex; align-items: center; justify-content: center;
        font-size: 1.5rem;
        margin-right: 15px;
        box-shadow: 0 0 15px rgba(239, 68, 68, 0.4);
    }

    /* LISTAS */
    .rule-list {
        list-style: none;
        padding: 20px;
        margin: 0;
    }
    .rule-list li {
        margin-bottom: 15px;
        padding-left: 20px;
        position: relative;
        line-height: 1.6;
        color: var(--text-soft);
    }
    /* Marcador personalizado */
    .rule-list li::before {
        content: "•";
        color: var(--danger);
        font-weight: bold;
        font-size: 1.5rem;
        position: absolute;
        left: 0;
        top: -5px;
    }
    
    strong { color: white; font-weight: 700; }
    
    /* ALERTA FINAL */
    .footer-alert {
        background: rgba(245, 158, 11, 0.1); /* Laranja suave */
        border: 1px solid rgba(245, 158, 11, 0.3);
        border-radius: 12px;
        padding: 30px;
        text-align: center;
    }

    /* UTILS */
    .text-highlight { color: #fca5a5; font-weight: bold; } /* Vermelho claro */
</style>

<div class="rules-hero">
    <div class="container" data-aos="fade-down">
        <h1 class="hero-title"><i class="bi bi-shield-exclamation me-3"></i>DIRETRIZES DO JOGO</h1>
        <p class="hero-subtitle">
            Para garantir a diversão e a integridade do mundo de <?php echo $serverName; ?>, 
            o cumprimento destas regras é obrigatório para todos os treinadores.
        </p>
    </div>
</div>

<div class="container my-5">

    <div class="row g-4">
        
        <div class="col-lg-6" data-aos="fade-right">
            <div class="rule-card">
                <div class="card-header-custom">
                    <div class="icon-box"><i class="fas fa-comments"></i></div>
                    <div>
                        <h4 class="fw-bold text-white m-0">1. Conduta & Comunicação</h4>
                        <small class="text-highlight">TOLERÂNCIA ZERO</small>
                    </div>
                </div>
                <ul class="rule-list">
                    <li>
                        <strong>Discriminação e Ódio:</strong> Racismo, sexismo, homofobia, xenofobia ou qualquer discurso de ódio resultará em <span class="text-danger fw-bold">banimento imediato e permanente</span>. Respeito é a base da nossa comunidade.
                    </li>
                    <li>
                        <strong>Conteúdo Ofensivo:</strong> É proibido compartilhar links, imagens ou textos com conteúdo pornográfico, violência extrema ou ilegal no chat global, guildas ou mensagens privadas.
                    </li>
                    <li>
                        <strong>Spam e Flood:</strong> Não atrapalhe a comunicação dos outros. O uso excessivo de Caps Lock, repetição de mensagens ou divulgação de outros servidores resultará em silenciamento (mute).
                    </li>
                    <li>
                        <strong>Assédio (Harassment):</strong> Perseguição, ameaças ou bullying contra jogadores ou membros da Staff não serão tolerados.
                    </li>
                    <li>
                        <strong>Falsa Identidade:</strong> É proibido fingir ser membro da Staff (GM, CM, Tutor) para enganar outros jogadores.
                    </li>
                </ul>
            </div>
        </div>

        <div class="col-lg-6" data-aos="fade-left">
            <div class="rule-card">
                <div class="card-header-custom">
                    <div class="icon-box"><i class="fas fa-ban"></i></div>
                    <div>
                        <h4 class="fw-bold text-white m-0">2. Trapaças (Cheating)</h4>
                        <small class="text-highlight">ANTI-JOGO</small>
                    </div>
                </div>
                <ul class="rule-list">
                    <li>
                        <strong>Botting e Macros:</strong> O uso de softwares de terceiros para automatizar ações (caçar, pescar, usar potions) é estritamente proibido. Nosso sistema detecta padrões inumanos.
                    </li>
                    <li>
                        <strong>Exploração de Bugs:</strong> Se encontrar um erro no jogo, reporte imediatamente. Abusar de falhas para duplicar itens, ganhar experiência ou dinheiro injustamente levará ao <span class="text-danger fw-bold">reset ou banimento</span> da conta.
                    </li>
                    <li>
                        <strong>Multi-Client (MC):</strong> Verifique o limite de clientes permitidos por IP nas notícias do servidor. O abuso de MC para farm ou dominar eventos é proibido.
                    </li>
                    <li>
                        <strong>Comércio Ilegal (RMT):</strong> A venda de contas, itens ou moeda do jogo por <u>dinheiro real</u> é proibida. Contas envolvidas serão congeladas.
                    </li>
                    <li>
                        <strong>Hacking:</strong> Tentativas de ataque ao servidor ou roubo de contas resultarão em bloqueio de IP e medidas legais.
                    </li>
                </ul>
            </div>
        </div>

        <div class="col-12" data-aos="fade-up">
            <div class="rule-card" style="border-top-color: var(--warning);">
                <div class="card-header-custom" style="background: rgba(245, 158, 11, 0.1);">
                    <div class="icon-box" style="background: var(--warning);"><i class="fas fa-gamepad"></i></div>
                    <div>
                        <h4 class="fw-bold text-white m-0">3. Regras de Jogo e PvP</h4>
                        <small class="text-warning fw-bold" style="color: #fcd34d !important;">MECÂNICAS</small>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <ul class="rule-list">
                            <li>
                                <strong>Power Abuse:</strong> Em servidores PvP, matar jogadores excessivamente sem motivo (especialmente níveis muito baixos) de forma a impedir que joguem pode ser punido a critério da Staff.
                            </li>
                            <li>
                                <strong>Luring:</strong> Atrair monstros fortes para áreas de iniciantes ou para matar jogadores AFK intencionalmente é considerado comportamento tóxico.
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <ul class="rule-list">
                            <li>
                                <strong>Bloqueio de Respawn (Trap):</strong> É proibido bloquear passagens estreitas, escadas ou teletransportes de forma que impeça a circulação de outros jogadores.
                            </li>
                            <li>
                                <strong>Roubo de Loot:</strong> Em áreas não-PvP, jogar itens em cima do corpo (depot/loot) de outro jogador para impedir que ele pegue seu prêmio é passível de punição.
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <div class="footer-alert mt-5" data-aos="zoom-in">
        <h4 class="text-warning fw-bold mb-3"><i class="fas fa-balance-scale me-2"></i> CONSIDERAÇÕES FINAIS</h4>
        <p class="text-soft fs-5 mb-0">
            A ignorância das regras não isenta o jogador da punição. A equipe de <?php echo $serverName; ?> reserva-se o direito de julgar casos não especificados aqui para manter a ordem do servidor. Jogue com honra!
        </p>
    </div>

</div>

<script>
    AOS.init();
</script>

<?php include 'includes/footer.php'; ?>