<?php
// sell_character.php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
require 'includes/conexao.php';

if (!isset($_SESSION['account_id'])) {
    header("Location: login.php");
    exit;
}

$account_id = $_SESSION['account_id'];
$action = $_REQUEST['action'] ?? '';
$player_id = $_REQUEST['player_id'] ?? ($_GET['id'] ?? 0);
$msg = '';

// Buscar configurações da venda
$sellerConfig = $pdo->query("SELECT * FROM character_seller_config WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
$minLevel = $sellerConfig['min_level_to_sell'] ?? 100;
$minPrice = $sellerConfig['min_price_pps'] ?? 50;
$commission_percent = $sellerConfig['admin_commission_percent'] ?? 10;
$storage_key = $sellerConfig['char_item_storage_key'] ?? 98765;

// Função para buscar nome do item
function getItemName($pdo, $item_id) {
    $stmt = $pdo->prepare("SELECT name FROM items_data WHERE item_id = ?");
    $stmt->execute([$item_id]);
    return $stmt->fetchColumn() ?? "Item Desconhecido (ID: $item_id)";
}

// ----------------------------------------------------
// AÇÃO: LISTAR PARA VENDA (POST)
// ----------------------------------------------------
if ($action == 'list_for_sale' && $_SERVER['REQUEST_METHOD'] == 'POST') {
    $price = (int)($_POST['price'] ?? 0);

    // 1. Validar Player
    $stmtChar = $pdo->prepare("SELECT name, level, online FROM players WHERE id = ? AND account_id = ?");
    $stmtChar->execute([$player_id, $account_id]);
    $char = $stmtChar->fetch(PDO::FETCH_ASSOC);

    if (!$char) {
        $msg = '<div class="alert alert-danger"><i class="fas fa-times-circle me-2"></i> Personagem não encontrado ou não pertence a esta conta.</div>';
    } elseif ($char['online'] == 1) {
        $msg = '<div class="alert alert-danger"><i class="fas fa-times-circle me-2"></i> O personagem deve estar offline para ser vendido.</div>';
    } elseif ($char['level'] < $minLevel) {
        $msg = '<div class="alert alert-danger"><i class="fas fa-times-circle me-2"></i> Nível muito baixo. O mínimo é ' . $minLevel . '.</div>';
    } elseif ($price < $minPrice) {
        $msg = '<div class="alert alert-danger"><i class="fas fa-times-circle me-2"></i> Preço muito baixo. O mínimo é ' . $minPrice . ' PPS.</div>';
    } else {
        try {
            // 2. Marcar para Venda
            $pdo->beginTransaction();
            $stmt = $pdo->prepare("UPDATE players SET on_sale = 1, sale_price = ?, lastlogout = ? WHERE id = ? AND account_id = ?");
            $stmt->execute([$price, time(), $player_id, $account_id]);
            
            // 3. MOVIMENTO CRÍTICO: Mover ou Marcar Itens
            // No seu ambiente real de Poketibia, você precisa de um script Lua/Game para
            // verificar itens do personagem, remover GOLD/ITENS NÃO VENDÁVEIS
            // e transferir o Depot Locker (marcado pela Storage Key) para uma conta/house de Venda.
            // A solução abaixo é SIMPLES, apenas marca o char.
            // Para uma solução completa, **o servidor deve mover os itens e o gold.**
            
            $pdo->commit();
            
            $msg = '<div class="alert alert-success"><i class="fas fa-check-circle me-2"></i> Personagem <strong>' . htmlspecialchars($char['name']) . '</strong> listado para venda por ' . $price . ' PPS!</div>';
        } catch (Exception $e) {
            $pdo->rollBack();
            $msg = '<div class="alert alert-danger">Erro ao listar para venda: ' . $e->getMessage() . '</div>';
        }
    }
}

// ----------------------------------------------------
// AÇÃO: CANCELAR VENDA (GET)
// ----------------------------------------------------
if ($action == 'cancel' && $_SERVER['REQUEST_METHOD'] == 'GET') {
    // 1. Validar Player
    $stmtChar = $pdo->prepare("SELECT name FROM players WHERE id = ? AND account_id = ? AND on_sale = 1");
    $stmtChar->execute([$player_id, $account_id]);
    $char = $stmtChar->fetch(PDO::FETCH_ASSOC);

    if (!$char) {
        $msg = '<div class="alert alert-danger"><i class="fas fa-times-circle me-2"></i> Personagem não está à venda ou não pertence a esta conta.</div>';
    } else {
        try {
            // 2. Cancelar a Venda
            $pdo->beginTransaction();
            $stmt = $pdo->prepare("UPDATE players SET on_sale = 0, sale_price = NULL WHERE id = ? AND account_id = ?");
            $stmt->execute([$player_id, $account_id]);
            
            // 3. MOVIMENTO CRÍTICO: Reverter Itens
            // Aqui, o script Lua/Game precisa devolver os itens que foram movidos para a conta/house de venda.
            
            $pdo->commit();
            $msg = '<div class="alert alert-info"><i class="fas fa-info-circle me-2"></i> Venda de <strong>' . htmlspecialchars($char['name']) . '</strong> cancelada com sucesso!</div>';
        } catch (Exception $e) {
            $pdo->rollBack();
            $msg = '<div class="alert alert-danger">Erro ao cancelar venda: ' . $e->getMessage() . '</div>';
        }
    }
}

// Redireciona de volta para a conta após o processamento
$_SESSION['temp_msg'] = $msg;
header("Location: account.php");
exit;