<?php
// Simulação das variáveis de configuração (Definir estas variáveis é crucial para o header e footer)
$siteConfig = [
    'server_name' => 'PokeServer',
    'color_header' => '#dc2626', // Vermelho Principal (Pokémon)
    'color_footer' => '#f8f9fa'  // Fundo Claro
];

// Requer o header, que deve conter <html>, <head>, <body> e o cabeçalho de navegação
require_once('includes/header.php'); 
?>

<div class="container my-5">
    <h1 class="text-center mb-4 text-primary">Termos de Uso e Serviço</h1>
    <p class="text-muted text-center mb-5 fst-italic">A leitura e aceitação destes termos são obrigatórias para a criação da conta.</p>
    
    <section class="mb-5">
        <h2 class="h4 mb-3 fw-bold">1. Aceitação dos Termos</h2>
        <p>Ao se registrar e acessar o <strong>PokeServer</strong> (o "Serviço"), você concorda em cumprir e estar vinculado a estes Termos de Uso, à nossa <a href="politicas.php">Política de Privacidade</a> e às <a href="regras.php">Regras do Jogo</a>. Se você não concordar com qualquer parte destes termos, não deve usar o Serviço.</p>
    </section>

    <hr>
    
    <section class="mb-5">
        <h2 class="h4 mb-3 fw-bold">2. Propriedade e Segurança da Conta</h2>
        <p>O Serviço é licenciado a você, não vendido. Você possui o direito de usar sua conta, mas o Serviço detém a propriedade intelectual dos dados do jogo.</p>
        <ul>
            <li><strong>Propriedade:</strong> Sua conta é estritamente pessoal e intransferível. Você é o único responsável pela segurança da sua senha e por todas as atividades que ocorrem sob sua conta. Nunca compartilhe sua senha.</li>
            <li><strong>Direitos sobre o Conteúdo:</strong> Você reconhece que todo o conteúdo do jogo, incluindo itens, personagens e Pokémon, são de propriedade intelectual do PokeServer. O uso é licenciado a você, mas a posse e o direito de distribuição permanecem com o Servidor.</li>
            <li><strong>Transferência/Venda (RMT):</strong> A venda, troca ou doação de contas, personagens ou itens por **dinheiro real (RMT - Real Money Trading)** é estritamente proibida e resultará em banimento permanente.</li>
        </ul>
    </section>

    <hr>

    <section class="mb-5">
        <h2 class="h4 mb-3 fw-bold">3. Conteúdo e Propriedade Intelectual</h2>
        <p>O PokeServer é um *fan site* e não é afiliado à Nintendo, Creatures Inc. ou GAME FREAK Inc. Todo o conteúdo original de Pokémon (nomes, *sprites* oficiais, etc.) é de propriedade de seus respectivos detentores de direitos autorais. O conteúdo exclusivo do PokeServer, incluindo mapas, *sprites* customizados e scripts de jogabilidade, é de nossa propriedade.</p>
    </section>

    <hr>

    <section class="mb-5">
        <h2 class="h4 mb-3 fw-bold">4. Doações e Recompensas Virtuais</h2>
        <p>As doações feitas ao PokeServer são **voluntárias** e destinam-se a cobrir os custos de manutenção (servidores, desenvolvimento, licenças, etc.).</p>
        <ul>
            <li><strong>Não Reembolsável:</strong> Todos os pagamentos são considerados doações e **não são reembolsáveis**, exceto em circunstâncias específicas e a critério exclusivo da administração.</li>
            <li><strong>Itens Virtuais:</strong> As recompensas virtuais recebidas em troca da doação não representam uma compra de propriedade, mas sim um benefício temporário dentro da licença de uso do jogo.</li>
        </ul>
    </section>

    <hr>

    <section class="mb-5">
        <h2 class="h4 mb-3 fw-bold">5. Suspensão e Encerramento de Conta</h2>
        <p>O PokeServer se reserva o direito de **suspender, banir ou encerrar** qualquer conta a qualquer momento e por qualquer motivo, especialmente em caso de violação destes Termos ou das Regras do Jogo, sem aviso prévio ou obrigação de reembolso.</p>
    </section>

    <div class="alert alert-warning text-center">
        <p class="mb-0 fw-bold">Ao jogar, você reconhece que leu e aceitou integralmente estes Termos de Uso.</p>
    </div>
</div>

<?php 
// Requer o footer, que deve incluir o rodapé, o aviso de cookies e fechar as tags
require_once('includes/footer.php'); 
?>