<?php
// Força mostrar erros na tela
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h1>Relatório de Diagnóstico (Linux/Ubuntu)</h1>";
echo "<hr>";

// 1. Teste Básico do PHP
echo "<h3>1. Status do PHP</h3>";
echo "O PHP está interpretando códigos? <strong style='color:green'>SIM</strong><br>";
echo "Usuário do Sistema: <strong>" . exec('whoami') . "</strong> (Deve ser www-data)<br>";

// 2. Verifica se o arquivo de conexão existe
echo "<h3>2. Arquivo de Conexão</h3>";
$arquivo_conexao = __DIR__ . '/includes/conexao.php';

if (file_exists($arquivo_conexao)) {
    echo "Arquivo 'includes/conexao.php' encontrado: <strong style='color:green'>OK</strong><br>";
    
    // Tenta incluir o arquivo
    try {
        require_once($arquivo_conexao);
        echo "Inclusão do arquivo: <strong style='color:green'>OK</strong><br>";
    } catch (Exception $e) {
        echo "Erro ao incluir arquivo: <strong style='color:red'>" . $e->getMessage() . "</strong><br>";
    }

} else {
    echo "Arquivo 'includes/conexao.php' encontrado: <strong style='color:red'>NÃO ENCONTRADO</strong><br>";
    echo "Caminho procurado: " . $arquivo_conexao . "<br>";
    die("<hr>Arrume o arquivo de conexão primeiro.");
}

// 3. Teste de Conexão com Banco
echo "<h3>3. Conexão com MySQL</h3>";
if (isset($pdo)) {
    echo "Objeto PDO detectado: <strong style='color:green'>OK</strong><br>";
    try {
        $query = $pdo->query("SELECT database()");
        $nome_banco = $query->fetchColumn();
        echo "Conectado com sucesso ao banco: <strong style='color:green'>" . $nome_banco . "</strong><br>";
    } catch (Exception $e) {
        echo "Erro ao consultar banco: <strong style='color:red'>" . $e->getMessage() . "</strong><br>";
    }
} else {
    echo "Objeto PDO: <strong style='color:red'>NÃO DETECTADO</strong> (Falha na conexão dentro do arquivo conexao.php)<br>";
}

// 4. Teste de Short Tags (Comum dar erro em migração)
echo "<h3>4. Compatibilidade</h3>";
echo "Se você ler isso, 'echo' funciona.<br>";
if ((bool)ini_get('short_open_tag') === false) {
    echo "Aviso: <strong>Short Tags (<?) estão DESATIVADAS.</strong> Se seu site usa '<?' em vez de '<?php', ele vai quebrar.<br>";
} else {
    echo "Short Tags estão ativadas.<br>";
}

echo "<hr><button onclick='location.reload()'>Testar Novamente</button>";
?>
